/*
 * Decompiled with CFR 0.152.
 */
package org.ada.web.util;

import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import org.ada.server.dataaccess.JsonUtil$;
import org.apache.commons.lang3.StringEscapeUtils;
import play.api.http.HeaderNames$;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.api.libs.json.JsObject;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class WebExportUtil$ {
    public static final WebExportUtil$ MODULE$;
    private final String DEFAULT_CHARSET;

    static {
        new WebExportUtil$();
    }

    private String DEFAULT_CHARSET() {
        return this.DEFAULT_CHARSET;
    }

    public Result jsonStreamToCsvFile(Source<JsObject, ?> source, Traversable<String> fieldNames, String filename, String delimiter, String eol, Traversable<Tuple2<String, String>> replacements, String charset) {
        String unescapedDelimiter = StringEscapeUtils.unescapeJava((String)delimiter);
        String unescapedEOL = StringEscapeUtils.unescapeJava((String)eol);
        String header2 = ((TraversableOnce)fieldNames.map((Function1)new Serializable(replacements){
            public static final long serialVersionUID = 0L;
            private final Traversable replacements$1;

            public final String apply(String fieldName) {
                return WebExportUtil$.MODULE$.org$ada$web$util$WebExportUtil$$headerFieldName$1(fieldName, this.replacements$1);
            }
            {
                this.replacements$1 = replacements$1;
            }
        }, Traversable$.MODULE$.canBuildFrom())).mkString(unescapedDelimiter);
        Source contentStream = (Source)source.map((Function1)new Serializable(fieldNames, replacements, unescapedDelimiter){
            public static final long serialVersionUID = 0L;
            private final Traversable fieldNames$1;
            private final Traversable replacements$1;
            private final String unescapedDelimiter$1;

            public final String apply(JsObject json) {
                return JsonUtil$.MODULE$.jsonToDelimitedString(json, this.fieldNames$1, this.unescapedDelimiter$1, this.replacements$1);
            }
            {
                this.fieldNames$1 = fieldNames$1;
                this.replacements$1 = replacements$1;
                this.unescapedDelimiter$1 = unescapedDelimiter$1;
            }
        });
        Source stringStream = (Source)Source$.MODULE$.single((Object)header2).concat((Graph)contentStream).intersperse((Object)unescapedEOL);
        return this.streamToFile(stringStream, filename, charset);
    }

    public String jsonStreamToCsvFile$default$4() {
        return ",";
    }

    public String jsonStreamToCsvFile$default$5() {
        return "\n";
    }

    public Traversable<Tuple2<String, String>> jsonStreamToCsvFile$default$6() {
        return Nil$.MODULE$;
    }

    public String jsonStreamToCsvFile$default$7() {
        return this.DEFAULT_CHARSET();
    }

    public Result jsonStreamToJsonFile(Source<JsObject, ?> source, String filename, String charset) {
        Source stringStream = (Source)source.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsObject x$1) {
                return x$1.toString();
            }
        }).intersperse((Object)"[", (Object)",\n", (Object)"]");
        return this.streamToFile(stringStream, filename, charset);
    }

    public String jsonStreamToJsonFile$default$3() {
        return this.DEFAULT_CHARSET();
    }

    private String replaceAll(Traversable<Tuple2<String, String>> replacements, String value2) {
        return (String)replacements.foldLeft((Object)value2, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$1, Tuple2<String, String> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String from = (String)tuple22._1();
                        String to = (String)tuple22._2();
                        String string2 = string.replaceAll(from, to);
                        return string2;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public Result stringToFile(String content, String filename, String charset) {
        Source source = Source$.MODULE$.single((Object)content);
        return this.streamToFile(source, filename, charset);
    }

    public String stringToFile$default$3() {
        return this.DEFAULT_CHARSET();
    }

    public Result streamToFile(Source<String, ?> source, String filename, String charset) {
        Source byteStream = (Source)source.map((Function1)new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final String charset$1;

            public final ByteString apply(String x$2) {
                return ByteString$.MODULE$.apply(x$2, this.charset$1);
            }
            {
                this.charset$1 = charset$1;
            }
        });
        return this.streamToFileChunked(byteStream, filename);
    }

    public Result streamToFile(Source<ByteString, ?> source, String filename) {
        return new Result(ResponseHeader$.MODULE$.apply(200, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONTENT_DISPOSITION()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"attachment; filename=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})))})), ResponseHeader$.MODULE$.apply$default$3()), (HttpEntity)new HttpEntity.Streamed(source, (Option)None$.MODULE$, (Option)new Some((Object)"application/x-download")));
    }

    public String streamToFile$default$3() {
        return this.DEFAULT_CHARSET();
    }

    public Result streamToFileChunked(Source<ByteString, ?> source, String filename) {
        Source chunked = (Source)source.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HttpChunk.Chunk apply(ByteString x$3) {
                return new HttpChunk.Chunk(x$3);
            }
        });
        return new Result(ResponseHeader$.MODULE$.apply(200, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONTENT_DISPOSITION()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"attachment; filename=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})))})), ResponseHeader$.MODULE$.apply$default$3()), (HttpEntity)new HttpEntity.Chunked(chunked, (Option)new Some((Object)"application/x-download")));
    }

    public final String org$ada$web$util$WebExportUtil$$headerFieldName$1(String fieldName, Traversable replacements$1) {
        return JsonUtil$.MODULE$.unescapeKey(this.replaceAll((Traversable<Tuple2<String, String>>)replacements$1, fieldName));
    }

    private WebExportUtil$() {
        MODULE$ = this;
        this.DEFAULT_CHARSET = "UTF-8";
    }
}

