/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.atlassian.common;

import java.security.Principal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adeptnet.atlassian.common.Common;
import org.adeptnet.atlassian.saml.SAMLException;
import org.apache.commons.logging.Log;
import org.opensaml.ws.message.encoder.MessageEncodingException;

public interface AuthenticatorInterface {
    public Log getLog();

    public Common getCommon() throws IllegalStateException;

    public Principal getUser(String var1);

    public Principal getUserFromSession(HttpServletRequest var1);

    public boolean authoriseUserAndEstablishSession(HttpServletRequest var1, HttpServletResponse var2, Principal var3);

    default public void doRedirect(HttpServletRequest request, HttpServletResponse response, String relayState) {
        try {
            this.getCommon().doSAMLRedirect(request, response, relayState);
        }
        catch (SAMLException | MessageEncodingException ex) {
            this.getLog().fatal((Object)ex.getMessage(), ex);
        }
    }

    default public Principal getUserFromUserName(HttpServletRequest request, HttpServletResponse response, String userName, String method) {
        Log log = this.getLog();
        Principal user = this.getUser(userName);
        if (user == null) {
            log.warn((Object)String.format("User not found: %s", userName));
            return null;
        }
        log.info((Object)String.format("Logged in %s via %s", user, method));
        if (!this.authoriseUserAndEstablishSession(request, response, user)) {
            log.warn((Object)String.format("User not authorised: %s", userName));
            return null;
        }
        return user;
    }

    default public Principal getUserCommon(HttpServletRequest request, HttpServletResponse response) {
        Principal userSession = this.getUserFromSession(request);
        if (userSession != null) {
            return userSession;
        }
        Common common = this.getCommon();
        String krb5User = common.getKrb5UserName(request);
        if (krb5User != null) {
            return this.getUserFromUserName(request, response, krb5User, "KRB5");
        }
        String samlUser = common.getSAMLUserName(request);
        if (samlUser != null) {
            return this.getUserFromUserName(request, response, samlUser, "SAML");
        }
        if (response == null) {
            return null;
        }
        if (common.isKrb5Enabled()) {
            String uri = request.getRequestURI().toLowerCase(Locale.UK);
            if (!common.krb5Skip401(uri)) {
                response.setStatus(401);
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
        }
        return null;
    }
}

