/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.atlassian.kerberos;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.adeptnet.atlassian.kerberos.Krb5Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class Krb5 {
    public static final String FAILED = "FAILED";
    private static final Log LOG = LogFactory.getLog(Krb5.class);
    private final Krb5Config config;

    public Krb5(Krb5Config config) {
        this.config = config;
    }

    private Configuration getJaasKrb5TicketCfg(final String principal) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("principal", principal);
                options.put("realm", Krb5.this.config.getRealm());
                options.put("keyTab", Krb5.this.config.getKeytab().getAbsolutePath());
                options.put("doNotPrompt", "true");
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("isInitiator", "false");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String isTicketValid(String spn, byte[] ticket) {
        LoginContext ctx = null;
        try {
            String username;
            KerberosPrincipal principal = new KerberosPrincipal(spn, 2);
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(principal);
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            ctx = new LoginContext(this.config.getContextName(), subject, null, this.getJaasKrb5TicketCfg(spn));
            ctx.login();
            Krb5TicketValidateAction validateAction = new Krb5TicketValidateAction(ticket, spn);
            String string = username = Subject.doAs(subject, validateAction);
            return string;
        }
        catch (PrivilegedActionException | LoginException e) {
            LOG.fatal((Object)spn, (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.logout();
                }
            }
            catch (LoginException e2) {
                LOG.fatal((Object)spn, (Throwable)e2);
            }
        }
        return FAILED;
    }

    private class Krb5TicketValidateAction
    implements PrivilegedExceptionAction<String> {
        private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
        private final byte[] ticket;
        private final String spn;

        public Krb5TicketValidateAction(byte[] ticket, String spn) {
            this.ticket = ticket;
            this.spn = spn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String run() throws GSSException {
            Oid spnegoOid = new Oid(SPNEGO_OID);
            GSSManager gssmgr = GSSManager.getInstance();
            GSSName serviceName = gssmgr.createName(this.spn, GSSName.NT_USER_NAME);
            GSSCredential serviceCredentials = gssmgr.createCredential(serviceName, Integer.MAX_VALUE, spnegoOid, 2);
            GSSContext gssContext = gssmgr.createContext(serviceCredentials);
            try {
                gssContext.acceptSecContext(this.ticket, 0, this.ticket.length);
                String string = gssContext.getSrcName().toString();
                return string;
            }
            finally {
                gssContext.dispose();
            }
        }
    }
}

