/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.atlassian.saml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.xml.bind.DatatypeConverter;
import org.adeptnet.atlassian.saml.SAMLException;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IdPConfig {
    private String entityId;
    private String loginUrl;
    private Certificate cert;

    public IdPConfig() {
    }

    public IdPConfig(File metadataFile) throws SAMLException {
        EntityDescriptor edesc;
        BasicParserPool parsers = new BasicParserPool();
        parsers.setNamespaceAware(true);
        try {
            Document doc = parsers.parse((InputStream)new FileInputStream(metadataFile));
            Element root = doc.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            edesc = (EntityDescriptor)unmarshallerFactory.getUnmarshaller(root).unmarshall(root);
        }
        catch (IOException | UnmarshallingException | XMLParserException e) {
            throw new SAMLException(e);
        }
        IDPSSODescriptor idpDesc = edesc.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpDesc == null) {
            throw new SAMLException("No IDP SSO descriptor found");
        }
        String _loginUrl = null;
        for (SingleSignOnService svc : idpDesc.getSingleSignOnServices()) {
            if (!svc.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) continue;
            _loginUrl = svc.getLocation();
            break;
        }
        if (_loginUrl == null) {
            throw new SAMLException("No acceptable Single Sign-on Service found");
        }
        Certificate _cert = null;
        block5: for (KeyDescriptor kdesc : idpDesc.getKeyDescriptors()) {
            KeyInfo ki;
            if (kdesc.getUse() != UsageType.SIGNING || (ki = kdesc.getKeyInfo()) == null) continue;
            for (X509Data x509data : ki.getX509Datas()) {
                for (X509Certificate xcert : x509data.getX509Certificates()) {
                    try {
                        _cert = this.certFromString(xcert.getValue());
                        break block5;
                    }
                    catch (CertificateException e) {
                    }
                }
            }
        }
        if (_cert == null) {
            throw new SAMLException("No valid signing cert found");
        }
        this.setEntityId(edesc.getEntityID());
        this.setLoginUrl(_loginUrl);
        this.setCert(_cert);
    }

    private Certificate certFromString(String b64data) throws CertificateException {
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)b64data);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(new ByteArrayInputStream(decoded));
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setCert(Certificate cert) {
        this.cert = cert;
    }

    public Certificate getCert() {
        return this.cert;
    }
}

