/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.atlassian.saml;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import javax.xml.bind.DatatypeConverter;
import org.adeptnet.atlassian.saml.AttributeSet;
import org.adeptnet.atlassian.saml.IdPConfig;
import org.adeptnet.atlassian.saml.SAMLConfig;
import org.adeptnet.atlassian.saml.SAMLException;
import org.adeptnet.atlassian.saml.SPConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAMLClient {
    private static final Log LOG = LogFactory.getLog(SAMLClient.class);
    private final SAMLConfig config;
    private final SignatureValidator sigValidator;
    private final BasicParserPool parsers;
    private static final int slack = 300;

    public SAMLClient(SAMLConfig config) throws SAMLException {
        this.config = config;
        BasicCredential cred = new BasicCredential();
        cred.setEntityId(config.getIdPConfig().getEntityId());
        cred.setPublicKey(config.getIdPConfig().getCert().getPublicKey());
        this.sigValidator = new SignatureValidator((Credential)cred);
        this.parsers = new BasicParserPool();
        this.parsers.setNamespaceAware(true);
    }

    public IdPConfig getIdPConfig() {
        return this.config.getIdPConfig();
    }

    public SPConfig getSPConfig() {
        return this.config.getSPConfig();
    }

    private Response parseResponse(String authnResponse) throws SAMLException {
        try {
            Document doc = this.parsers.getBuilder().parse(new InputSource(new StringReader(authnResponse)));
            Element root = doc.getDocumentElement();
            return (Response)Configuration.getUnmarshallerFactory().getUnmarshaller(root).unmarshall(root);
        }
        catch (IOException | UnmarshallingException | XMLParserException | SAXException e) {
            throw new SAMLException(e);
        }
    }

    private void validate(Response response) throws ValidationException {
        Signature sig1 = response.getSignature();
        this.sigValidator.validate(sig1);
        if (response.getStatus() == null || response.getStatus().getStatusCode() == null || !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            throw new ValidationException("Response has an unsuccessful status code");
        }
        if (!this.config.getSPConfig().getAcs().equals(response.getDestination())) {
            throw new ValidationException("Response is destined for a different endpoint");
        }
        DateTime now = DateTime.now();
        DateTime issueInstant = response.getIssueInstant();
        if (issueInstant != null) {
            if (issueInstant.isBefore((ReadableInstant)now.minusDays(1).minusSeconds(300))) {
                throw new ValidationException("Response IssueInstant is in the past");
            }
            if (issueInstant.isAfter((ReadableInstant)now.plusDays(1).plusSeconds(300))) {
                throw new ValidationException("Response IssueInstant is in the future");
            }
        }
        for (Assertion assertion : response.getAssertions()) {
            if (!assertion.isSigned()) {
                throw new ValidationException("Assertion must be signed");
            }
            Signature sig2 = assertion.getSignature();
            this.sigValidator.validate(sig2);
            if (assertion.getAuthnStatements().isEmpty()) {
                throw new ValidationException("Assertion should contain an AuthnStatement");
            }
            for (AuthnStatement as : assertion.getAuthnStatements()) {
                if (as.getSessionNotOnOrAfter() == null) {
                    LOG.error((Object)"SessionNotOnOrAfter is null");
                    continue;
                }
                DateTime exp = as.getSessionNotOnOrAfter().plusSeconds(300);
                if (exp == null || !now.isEqual((ReadableInstant)exp) && !now.isAfter((ReadableInstant)exp)) continue;
                throw new ValidationException("AuthnStatement has expired");
            }
            if (assertion.getConditions() == null) {
                throw new ValidationException("Assertion should contain conditions");
            }
            DateTime instant = assertion.getIssueInstant();
            if (instant != null) {
                if (instant.isBefore((ReadableInstant)now.minusDays(1).minusSeconds(300))) {
                    throw new ValidationException("Response IssueInstant is in the past");
                }
                if (instant.isAfter((ReadableInstant)now.plusDays(1).plusSeconds(300))) {
                    throw new ValidationException("Response IssueInstant is in the future");
                }
            }
            Conditions conditions = assertion.getConditions();
            DateTime notBefore = conditions.getNotBefore();
            DateTime notOnOrAfter = conditions.getNotOnOrAfter();
            if (notBefore == null) {
                notBefore = now;
            }
            if (notBefore == null || notOnOrAfter == null) {
                throw new ValidationException("Assertion conditions must have limits");
            }
            notBefore = notBefore.minusSeconds(300);
            notOnOrAfter = notOnOrAfter.plusSeconds(300);
            if (now.isBefore((ReadableInstant)notBefore)) {
                throw new ValidationException("Assertion conditions is in the future");
            }
            if (now.isEqual((ReadableInstant)notOnOrAfter) || now.isAfter((ReadableInstant)notOnOrAfter)) {
                throw new ValidationException("Assertion conditions is in the past");
            }
            Subject subject = assertion.getSubject();
            if (subject != null && !subject.getSubjectConfirmations().isEmpty()) {
                boolean foundRecipient = false;
                for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
                    DateTime chkdate;
                    if (sc.getSubjectConfirmationData() == null) continue;
                    SubjectConfirmationData scd = sc.getSubjectConfirmationData();
                    if (scd.getNotOnOrAfter() != null && (now.isEqual((ReadableInstant)(chkdate = scd.getNotOnOrAfter().plusSeconds(300))) || now.isAfter((ReadableInstant)chkdate))) {
                        throw new ValidationException("SubjectConfirmationData is in the past");
                    }
                    if (!this.config.getSPConfig().getAcs().equals(scd.getRecipient())) continue;
                    foundRecipient = true;
                }
                if (!foundRecipient) {
                    throw new ValidationException("No SubjectConfirmationData found for ACS");
                }
            }
            if (conditions.getAudienceRestrictions().isEmpty()) {
                throw new ValidationException("Assertion conditions must have audience restrictions");
            }
            if (conditions.getAudienceRestrictions().size() > 1) {
                throw new ValidationException("Assertion contains multiple audience restrictions");
            }
            AudienceRestriction ar = (AudienceRestriction)conditions.getAudienceRestrictions().get(0);
            boolean foundSP = false;
            for (Audience a : ar.getAudiences()) {
                if (!this.config.getSPConfig().getEntityId().equals(a.getAudienceURI())) continue;
                foundSP = true;
            }
            if (foundSP) continue;
            throw new ValidationException("Assertion audience does not include issuer");
        }
    }

    private Signature getSignature() {
        try {
            char[] jksPassword = this.config.getKeystorePassword();
            String alias = this.config.getCertificateAlias();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fileInputStream = new FileInputStream(this.config.getKeystore());){
                keyStore.load(fileInputStream, jksPassword);
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(jksPassword));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            X509Certificate certificate = (X509Certificate)privateKeyEntry.getCertificate();
            BasicX509Credential credential = new BasicX509Credential();
            credential.setEntityCertificate(certificate);
            credential.setPrivateKey(privateKey);
            Signature signature = (Signature)org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)credential);
            SecurityConfiguration securityConfiguration = Configuration.getGlobalSecurityConfiguration();
            String keyInfoGeneratorProfile = null;
            SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)credential, (SecurityConfiguration)securityConfiguration, keyInfoGeneratorProfile);
            return signature;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException | SecurityException ex) {
            Logger.getLogger(SAMLClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public AuthnRequest createAuthnRequest(String requestId) {
        AuthnRequest request = new AuthnRequestBuilder().buildObject();
        request.setAssertionConsumerServiceURL(this.config.getSPConfig().getAcs());
        request.setDestination(this.config.getIdPConfig().getLoginUrl());
        request.setIssueInstant(new DateTime());
        request.setID(requestId);
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        request.setNameIDPolicy(nameIDPolicy);
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(this.config.getSPConfig().getEntityId());
        request.setIssuer(issuer);
        request.setSignature(this.getSignature());
        return request;
    }

    private String _createAuthnRequest(String requestId) throws SAMLException {
        AuthnRequest request = this.createAuthnRequest(requestId);
        try {
            Element elem = Configuration.getMarshallerFactory().getMarshaller((XMLObject)request).marshall((XMLObject)request);
            Document document = elem.getOwnerDocument();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
            LSSerializer serializer = domImplLS.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            return serializer.writeToString(elem);
        }
        catch (MarshallingException e) {
            throw new SAMLException(e);
        }
    }

    private byte[] deflate(byte[] input) throws IOException {
        Deflater deflater = new Deflater(-1, true);
        deflater.setInput(input);
        deflater.finish();
        byte[] tmp = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (!deflater.finished()) {
            int count = deflater.deflate(tmp);
            bos.write(tmp, 0, count);
        }
        bos.close();
        deflater.end();
        return bos.toByteArray();
    }

    public String generateAuthnRequest(String requestId) throws SAMLException {
        String request = this._createAuthnRequest(requestId);
        try {
            byte[] compressed = this.deflate(request.getBytes("UTF-8"));
            return DatatypeConverter.printBase64Binary((byte[])compressed);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAMLException("Apparently your platform lacks UTF-8.  That's too bad.", e);
        }
        catch (IOException e) {
            throw new SAMLException("Unable to compress the AuthnRequest", e);
        }
    }

    public AttributeSet validateResponse(String _authnResponse) throws SAMLException {
        String authnResponse;
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)_authnResponse);
        try {
            authnResponse = new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SAMLException("UTF-8 is missing, oh well.", e);
        }
        Response response = this.parseResponse(authnResponse);
        try {
            this.validate(response);
        }
        catch (ValidationException e) {
            throw new SAMLException(e);
        }
        if (response.getAssertions().size() != 1) {
            throw new SAMLException("Response should have a single assertion.");
        }
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Subject subject = assertion.getSubject();
        if (subject == null) {
            throw new SAMLException("No subject contained in the assertion.");
        }
        if (subject.getNameID() == null) {
            throw new SAMLException("No NameID found in the subject.");
        }
        String nameId = subject.getNameID().getValue();
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        for (AttributeStatement atbs : assertion.getAttributeStatements()) {
            for (Attribute atb : atbs.getAttributes()) {
                String name = atb.getName();
                ArrayList<String> values = new ArrayList<String>();
                for (XMLObject obj : atb.getAttributeValues()) {
                    values.add(obj.getDOM().getTextContent());
                }
                attributes.put(name, values);
            }
        }
        return new AttributeSet(nameId, attributes);
    }
}

