/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.atlassian.common;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adeptnet.atlassian.common.Nameserver;
import org.adeptnet.atlassian.kerberos.Krb5;
import org.adeptnet.atlassian.kerberos.Krb5ConfigImpl;
import org.adeptnet.atlassian.saml.AttributeSet;
import org.adeptnet.atlassian.saml.SAMLClient;
import org.adeptnet.atlassian.saml.SAMLConfigImpl;
import org.adeptnet.atlassian.saml.SAMLException;
import org.adeptnet.atlassian.saml.SAMLInit;
import org.adeptnet.atlassian.saml.SAMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.impl.SingleSignOnServiceBuilder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;

public class Common {
    private static final Log LOG = LogFactory.getLog(Common.class);
    public static final String CREDS = "javax.security.auth.useSubjectCredsOnly";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";
    public static final String SAML_RESPONSE = "SAMLResponse";
    public static final String SAML_RELAYSTATE = "RelayState";
    public static final String SAML_SIGALG = "SigAlg";
    public static final String SAML_SIGNATURE = "Signature";
    public static final String KRB5_ENABLE = "krb5-enable";
    public static final String KRB5_SKIP401 = "krb5-skip401";
    public static final String KRB5_REALM = "krb5-realm";
    public static final String KRB5_KEYTAB = "krb5-keytab";
    public static final String KRB5_LOGIN_CONTEXT = "krb5-login-context";
    public static final String SAML_ENABLE = "saml-enable";
    public static final String SAML_IDP_CONFIG = "saml-idp-config";
    public static final String SAML_SP_CONFIG = "saml-sp-config";
    public static final String SAML_KEYSTORE_NAME = "saml-keystore-name";
    public static final String SAML_KEYSTORE_PASSWORD = "saml-keystore-password";
    public static final String SAML_CERTIFICATE_ALIAS = "saml-certificate-alias";
    private final Krb5ConfigImpl krb5Cfg = new Krb5ConfigImpl();
    private SAMLClient samlClient;
    private final SAMLConfigImpl samlCfg = new SAMLConfigImpl();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private boolean hasInit;
    private boolean krb5Enabled;
    private boolean samlEnabled;

    public Common check() throws IllegalStateException {
        if (!this.hasInit) {
            throw new IllegalStateException("Please INIT before use");
        }
        return this;
    }

    private void initSkip401(Map<String, String> params) {
        String[] skips;
        if (!params.containsKey(KRB5_SKIP401)) {
            return;
        }
        for (String _skip : skips = params.get(KRB5_SKIP401).split("\n")) {
            String skip = _skip.trim();
            if (skip.isEmpty()) continue;
            try {
                Pattern pattern = Pattern.compile(skip);
                this.patterns.add(pattern);
            }
            catch (PatternSyntaxException ex) {
                LOG.error((Object)String.format("skip401: %s - %s", skip, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void init(Map<String, String> params) {
        this.krb5Enabled = Boolean.valueOf(params.get(KRB5_ENABLE));
        this.initSkip401(params);
        this.krb5Cfg.setRealm(params.get(KRB5_REALM));
        if (params.containsKey(KRB5_KEYTAB)) {
            this.krb5Cfg.setKeytabName(params.get(KRB5_KEYTAB));
        }
        if (params.containsKey(KRB5_LOGIN_CONTEXT)) {
            this.krb5Cfg.setContextName(params.get(KRB5_LOGIN_CONTEXT));
        }
        this.samlEnabled = Boolean.valueOf(params.get(SAML_ENABLE));
        this.samlCfg.setIdpConfigName(params.get(SAML_IDP_CONFIG));
        this.samlCfg.setSpConfigName(params.get(SAML_SP_CONFIG));
        this.samlCfg.setKeystoreName(params.get(SAML_KEYSTORE_NAME));
        this.samlCfg.setKeystorePassword(params.get(SAML_KEYSTORE_PASSWORD));
        this.samlCfg.setCertificateAlias(params.get(SAML_CERTIFICATE_ALIAS));
        if (LOG.isDebugEnabled()) {
            LOG.debug(params);
            LOG.debug((Object)String.format("krb5Enabled: %s", this.krb5Enabled));
            LOG.debug((Object)String.format("samlEnabled: %s", this.samlEnabled));
        }
        this.hasInit = true;
    }

    private SAMLClient getSAMLClient(ServletContext servletContext) throws SAMLException {
        if (this.samlClient == null) {
            SAMLInit.initialize();
            this.samlCfg.init(this.getFileName(servletContext));
            this.samlClient = new SAMLClient(this.samlCfg);
        }
        return this.samlClient;
    }

    public void doSAMLRedirect(HttpServletRequest request, HttpServletResponse response, String relayState) throws SAMLException, MessageEncodingException {
        if (!this.samlEnabled) {
            throw new SAMLException("SAML is not enabled");
        }
        SAMLClient client = this.getSAMLClient(request.getServletContext());
        String requestId = SAMLUtils.generateRequestId();
        AuthnRequest authnRequest = client.createAuthnRequest(requestId);
        HttpServletResponseAdapter responseAdapter = new HttpServletResponseAdapter(response, true);
        BasicSAMLMessageContext context = new BasicSAMLMessageContext();
        SingleSignOnService endpoint = new SingleSignOnServiceBuilder().buildObject();
        endpoint.setLocation(client.getIdPConfig().getLoginUrl());
        context.setPeerEntityEndpoint((Endpoint)endpoint);
        context.setOutboundSAMLMessage((SAMLObject)authnRequest);
        context.setOutboundSAMLMessageSigningCredential(authnRequest.getSignature().getSigningCredential());
        context.setOutboundMessageTransport((OutTransport)responseAdapter);
        context.setRelayState(relayState == null ? "/" : relayState);
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.encode((MessageContext)context);
    }

    private String normalize(String data) {
        if (data.isEmpty()) {
            return data;
        }
        if (data.endsWith(".")) {
            return this.normalize(data.substring(0, data.length() - 1));
        }
        return data;
    }

    private String recurseResolveToA(Nameserver ns, Set<String> checked, String host) throws NamingException {
        if (checked.contains(host)) {
            throw new NamingException(String.format("Recursive Name Lookup: %s", checked));
        }
        String[] clookup = ns.lookup(host, "cname");
        if (clookup.length != 0) {
            checked.add(host);
            return this.recurseResolveToA(ns, checked, this.normalize(clookup[0]));
        }
        return host;
    }

    private Function<String, String> getFileName(ServletContext servletContext) {
        return fileName -> servletContext.getRealPath(fileName);
    }

    public String getKrb5UserName(HttpServletRequest request) {
        String username;
        String serverName;
        String[] ticketParts;
        if (!this.krb5Enabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"!krb5Enabled");
            }
            return null;
        }
        String _ticket = request.getHeader(AUTHORIZATION);
        if (_ticket == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Found Kerberos Ticket");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)_ticket);
        }
        if (!System.getProperties().containsKey(CREDS)) {
            LOG.warn((Object)String.format("Setting [%s] to false", CREDS));
            System.setProperty(CREDS, "false");
        }
        if ((ticketParts = _ticket.split(" ")).length != 2 || !NEGOTIATE.equals(ticketParts[0])) {
            LOG.error((Object)String.format("Invalid KRB5 Ticket: %s", _ticket));
            return null;
        }
        try {
            serverName = this.recurseResolveToA(new Nameserver(), new HashSet<String>(), request.getServerName());
        }
        catch (NamingException ex) {
            LOG.error((Object)String.format("Cannot Resolve %s - %s", request.getServerName(), ex.getMessage()), (Throwable)ex);
            return null;
        }
        byte[] ticket = Base64.getDecoder().decode(ticketParts[1]);
        this.krb5Cfg.init(this.getFileName(request.getServletContext()));
        String realm = String.format("@%s", this.krb5Cfg.getRealm());
        String spn = String.format("HTTP/%s%s", serverName, realm);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("SPN: %s", spn));
        }
        if ((username = new Krb5(this.krb5Cfg).isTicketValid(spn, ticket)) == null || !username.endsWith(realm)) {
            LOG.error((Object)String.format("Invalid username: %s", username));
            return null;
        }
        return username.split("@")[0];
    }

    public String getSAMLUserName(HttpServletRequest request) {
        AttributeSet aset;
        if (!this.samlEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"!samlEnabled");
            }
            return null;
        }
        String samlTicket = request.getParameter(SAML_RESPONSE);
        if (samlTicket == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Found SAML Ticket");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)samlTicket);
        }
        try {
            SAMLClient client = this.getSAMLClient(request.getServletContext());
            aset = "GET".equalsIgnoreCase(request.getMethod()) ? client.validateResponseGET(request.getQueryString()) : client.validateResponsePOST(samlTicket);
        }
        catch (SAMLException ex) {
            LOG.fatal((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        return aset.getNameId();
    }

    public boolean krb5Skip401(String uri) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isKrb5Enabled() {
        return this.krb5Enabled;
    }

    public boolean isSamlEnabled() {
        return this.samlEnabled;
    }
}

