/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.atlassian.common;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adeptnet.auth.kerberos.Krb5;
import org.adeptnet.auth.kerberos.Krb5ConfigImpl;
import org.adeptnet.auth.saml.AttributeSet;
import org.adeptnet.auth.saml.SAMLClient;
import org.adeptnet.auth.saml.SAMLConfigImpl;
import org.adeptnet.auth.saml.SAMLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.ws.message.encoder.MessageEncodingException;

public class Common {
    private static final Log LOG = LogFactory.getLog(Common.class);
    private static final String KRB5_ENABLE = "krb5-enable";
    private static final String KRB5_SKIP401 = "krb5-skip401";
    private static final String KRB5_REALM = "krb5-realm";
    private static final String KRB5_KEYTAB = "krb5-keytab";
    private static final String KRB5_LOGIN_CONTEXT = "krb5-login-context";
    private static final String SAML_ENABLE = "saml-enable";
    private static final String SAML_IDP_CONFIG = "saml-idp-config";
    private static final String SAML_SP_CONFIG = "saml-sp-config";
    private static final String SAML_KEYSTORE_NAME = "saml-keystore-name";
    private static final String SAML_KEYSTORE_PASSWORD = "saml-keystore-password";
    private static final String SAML_CERTIFICATE_ALIAS = "saml-certificate-alias";
    private final Krb5ConfigImpl krb5Cfg = new Krb5ConfigImpl();
    private SAMLClient samlClient;
    private final SAMLConfigImpl samlCfg = new SAMLConfigImpl();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private boolean hasInit;
    private boolean krb5Enabled;
    private boolean samlEnabled;

    public Common check() throws IllegalStateException {
        if (!this.hasInit) {
            throw new IllegalStateException("Please INIT before use");
        }
        return this;
    }

    private void initSkip401(Map<String, String> params) {
        String[] skips;
        if (!params.containsKey(KRB5_SKIP401)) {
            return;
        }
        for (String _skip : skips = params.get(KRB5_SKIP401).split("\n")) {
            String skip = _skip.trim();
            if (skip.isEmpty()) continue;
            try {
                Pattern pattern = Pattern.compile(skip);
                this.patterns.add(pattern);
            }
            catch (PatternSyntaxException ex) {
                LOG.error((Object)String.format("skip401: %s - %s", skip, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void init(Map<String, String> params) {
        this.krb5Enabled = Boolean.valueOf(params.get(KRB5_ENABLE));
        this.initSkip401(params);
        this.krb5Cfg.setRealm(params.get(KRB5_REALM));
        if (params.containsKey(KRB5_KEYTAB)) {
            this.krb5Cfg.setKeytabName(params.get(KRB5_KEYTAB));
        }
        if (params.containsKey(KRB5_LOGIN_CONTEXT)) {
            this.krb5Cfg.setContextName(params.get(KRB5_LOGIN_CONTEXT));
        }
        this.samlEnabled = Boolean.valueOf(params.get(SAML_ENABLE));
        this.samlCfg.setIdpConfigName(params.get(SAML_IDP_CONFIG));
        this.samlCfg.setSpConfigName(params.get(SAML_SP_CONFIG));
        this.samlCfg.setKeystoreName(params.get(SAML_KEYSTORE_NAME));
        this.samlCfg.setKeystorePassword(params.get(SAML_KEYSTORE_PASSWORD));
        this.samlCfg.setCertificateAlias(params.get(SAML_CERTIFICATE_ALIAS));
        if (LOG.isDebugEnabled()) {
            LOG.debug(params);
            LOG.debug((Object)String.format("krb5Enabled: %s", this.krb5Enabled));
            LOG.debug((Object)String.format("samlEnabled: %s", this.samlEnabled));
        }
        this.hasInit = true;
    }

    private SAMLClient getSAMLClient(ServletContext servletContext) throws SAMLException {
        if (this.samlClient == null) {
            this.samlCfg.init(this.getFileName(servletContext));
            this.samlClient = new SAMLClient(this.samlCfg);
        }
        return this.samlClient;
    }

    public void doSAMLRedirect(HttpServletRequest request, HttpServletResponse response, String relayState) throws SAMLException, MessageEncodingException {
        if (!this.samlEnabled) {
            throw new SAMLException("SAML is not enabled");
        }
        SAMLClient client = this.getSAMLClient(request.getServletContext());
        client.doSAMLRedirect(response, relayState);
    }

    private Function<String, String> getFileName(ServletContext servletContext) {
        return fileName -> servletContext.getRealPath(fileName);
    }

    public String getKrb5UserName(HttpServletRequest request) {
        String username;
        String ticket;
        if (!this.krb5Enabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"!krb5Enabled");
            }
            return null;
        }
        String _ticket = request.getHeader("Authorization");
        if (_ticket == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Found Kerberos Ticket");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)_ticket);
        }
        if ((ticket = Krb5.extractTicket(_ticket)) == null) {
            return null;
        }
        String serverName = Krb5.resolveServerName(request.getServerName());
        this.krb5Cfg.init(this.getFileName(request.getServletContext()));
        String realm = String.format("@%s", this.krb5Cfg.getRealm());
        String spn = String.format("HTTP/%s%s", serverName, realm);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("SPN: %s", spn));
        }
        if ((username = new Krb5(this.krb5Cfg).isTicketValid(spn, Base64.getDecoder().decode(ticket))) == null || !username.endsWith(realm)) {
            LOG.error((Object)String.format("Invalid username: %s", username));
            return null;
        }
        return username.split("@")[0];
    }

    public String getSAMLUserName(HttpServletRequest request) {
        AttributeSet aset;
        if (!this.samlEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"!samlEnabled");
            }
            return null;
        }
        String samlTicket = request.getParameter("SAMLResponse");
        if (samlTicket == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Found SAML Ticket");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)samlTicket);
        }
        try {
            SAMLClient client = this.getSAMLClient(request.getServletContext());
            aset = "GET".equalsIgnoreCase(request.getMethod()) ? client.validateResponseGET(request.getQueryString()) : client.validateResponsePOST(samlTicket);
        }
        catch (SAMLException ex) {
            LOG.fatal((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        return aset.getNameId();
    }

    public boolean krb5Skip401(String uri) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("krb5Skip401: %s", uri));
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isKrb5Enabled() {
        return this.krb5Enabled;
    }

    public boolean isSamlEnabled() {
        return this.samlEnabled;
    }
}

