/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.decoding;

import javax.servlet.http.HttpServletRequest;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.BasicURLComparator;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.ws.message.decoder.BaseMessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAMLMessageDecoder
extends BaseMessageDecoder
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAMLMessageDecoder.class);
    private URIComparator uriComparator;

    public BaseSAMLMessageDecoder() {
        this.setURIComparator(new BasicURLComparator());
    }

    public BaseSAMLMessageDecoder(ParserPool pool) {
        super(pool);
        this.setURIComparator(new BasicURLComparator());
    }

    public void setURIComparator(URIComparator comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("URI comparator may not be null");
        }
        this.uriComparator = comparator;
    }

    public URIComparator getURIComparator() {
        return this.uriComparator;
    }

    protected boolean isMessageSigned(SAMLMessageContext messageContext) {
        Object samlMessage = messageContext.getInboundSAMLMessage();
        if (samlMessage instanceof SignableSAMLObject) {
            return ((SignableSAMLObject)samlMessage).isSigned();
        }
        return false;
    }

    protected abstract boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext var1);

    protected abstract String getIntendedDestinationEndpointURI(SAMLMessageContext var1) throws MessageDecodingException;

    protected String getActualReceiverEndpointURI(SAMLMessageContext messageContext) throws MessageDecodingException {
        InTransport inTransport = messageContext.getInboundMessageTransport();
        if (!(inTransport instanceof HttpServletRequestAdapter)) {
            this.log.error("Message context InTransport instance was an unsupported type: {}", (Object)inTransport.getClass().getName());
            throw new MessageDecodingException("Message context InTransport instance was an unsupported type");
        }
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        StringBuffer urlBuilder = httpRequest.getRequestURL();
        return urlBuilder.toString();
    }

    protected boolean compareEndpointURIs(String messageDestination, String receiverEndpoint) throws MessageDecodingException {
        return this.getURIComparator().compare(messageDestination, receiverEndpoint);
    }

    protected void checkEndpointURI(SAMLMessageContext messageContext) throws SecurityException, MessageDecodingException {
        this.log.debug("Checking SAML message intended destination endpoint against receiver endpoint");
        String messageDestination = DatatypeHelper.safeTrimOrNullString(this.getIntendedDestinationEndpointURI(messageContext));
        boolean bindingRequires = this.isIntendedDestinationEndpointURIRequired(messageContext);
        if (messageDestination == null) {
            if (bindingRequires) {
                this.log.error("SAML message intended destination endpoint URI required by binding was empty");
                throw new SecurityException("SAML message intended destination (required by binding) was not present");
            }
            this.log.debug("SAML message intended destination endpoint in message was empty, not required by binding, skipping");
            return;
        }
        String receiverEndpoint = DatatypeHelper.safeTrimOrNullString(this.getActualReceiverEndpointURI(messageContext));
        this.log.debug("Intended message destination endpoint: {}", (Object)messageDestination);
        this.log.debug("Actual message receiver endpoint: {}", (Object)receiverEndpoint);
        boolean matched = this.compareEndpointURIs(messageDestination, receiverEndpoint);
        if (!matched) {
            this.log.error("SAML message intended destination endpoint '{}' did not match the recipient endpoint '{}'", (Object)messageDestination, (Object)receiverEndpoint);
            throw new SecurityException("SAML message intended destination endpoint did not match recipient endpoint");
        }
        this.log.debug("SAML message intended destination endpoint matched recipient endpoint");
    }
}

