/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.auth.kerberos;

import java.io.File;
import java.util.function.Function;
import org.adeptnet.auth.kerberos.Krb5Config;

public class Krb5ConfigImpl
implements Krb5Config {
    private String realm;
    private String contextName;
    private String keytabName;
    private File keytab;

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public File getKeytab() {
        return this.keytab;
    }

    public void setRealm(String realm) {
        if (realm == null) {
            throw new NullPointerException("Realm should never be null");
        }
        this.realm = realm;
        if (this.contextName == null) {
            this.setContextName(String.format("dynamic-%s", realm));
        }
        if (this.keytabName == null) {
            this.setKeytabName(String.format("%s.keytab", realm));
        }
    }

    public void setContextName(String contextName) {
        if (contextName == null) {
            throw new NullPointerException("ContextName should never be null");
        }
        this.contextName = contextName;
    }

    public String getKeytabName() {
        return this.keytabName;
    }

    public void setKeytabName(String keytabName) {
        if (keytabName == null) {
            throw new NullPointerException("KeytabName should never be null");
        }
        this.keytab = null;
        this.keytabName = keytabName;
    }

    public void init(Function<String, String> function) {
        if (this.keytab != null) {
            return;
        }
        this.keytab = new File(function.apply(this.getKeytabName()));
    }

    public void init() {
        this.init(fileName -> fileName);
    }
}

