/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.auth.saml;

import java.io.File;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.auth.saml.IdPConfig;
import org.adeptnet.auth.saml.SAMLConfig;
import org.adeptnet.auth.saml.SAMLException;
import org.adeptnet.auth.saml.SAMLInit;
import org.adeptnet.auth.saml.SPConfig;

public class SAMLConfigImpl
implements SAMLConfig {
    private static final Logger LOG = Logger.getLogger(SAMLConfigImpl.class.getName());
    private IdPConfig idpConfig;
    private String idpConfigName;
    private SPConfig spConfig;
    private String spConfigName;
    private File keystore;
    private String keystoreName;
    private char[] keystorePassword;
    private String certificateAlias;

    @Override
    public IdPConfig getIdPConfig() {
        return this.idpConfig;
    }

    @Override
    public SPConfig getSPConfig() {
        return this.spConfig;
    }

    public void setIdpConfig(IdPConfig idpConfig) {
        this.idpConfig = idpConfig;
    }

    public SAMLConfigImpl withIdpConfig(IdPConfig idpConfig) {
        this.setIdpConfig(idpConfig);
        return this;
    }

    public void setSpConfig(SPConfig spConfig) {
        this.spConfig = spConfig;
    }

    public SAMLConfigImpl withSpConfig(SPConfig spConfig) {
        this.setSpConfig(spConfig);
        return this;
    }

    @Override
    public File getKeystore() {
        return this.keystore;
    }

    public void setKeystore(File keystore) {
        this.keystore = keystore;
    }

    public SAMLConfigImpl withKeystore(File keystore) {
        this.setKeystore(keystore);
        return this;
    }

    @Override
    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        if (keystorePassword == null) {
            throw new NullPointerException("keystorePassword should never be null");
        }
        this.keystorePassword = keystorePassword;
    }

    public SAMLConfigImpl withKeystorePassword(char[] keystorePassword) {
        this.setKeystorePassword(keystorePassword);
        return this;
    }

    public void setKeystorePassword(String keystorePassword) {
        if (keystorePassword == null) {
            throw new NullPointerException("keystorePassword should never be null");
        }
        this.setKeystorePassword(keystorePassword.toCharArray());
    }

    public SAMLConfigImpl withKeystorePassword(String keystorePassword) {
        this.setKeystorePassword(keystorePassword);
        return this;
    }

    @Override
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        if (certificateAlias == null) {
            throw new NullPointerException("certificateAlias should never be null");
        }
        this.certificateAlias = certificateAlias;
    }

    public SAMLConfigImpl withCertificateAlias(String certificateAlias) {
        this.setCertificateAlias(certificateAlias);
        return this;
    }

    public String getKeystoreName() {
        return this.keystoreName;
    }

    public void setKeystoreName(String keystoreName) {
        if (keystoreName == null) {
            throw new NullPointerException("keystoreName should never be null");
        }
        this.keystoreName = keystoreName;
    }

    public SAMLConfigImpl withKeystoreName(String keystoreName) {
        this.setKeystoreName(keystoreName);
        return this;
    }

    public String getIdpConfigName() {
        return this.idpConfigName;
    }

    public void setIdpConfigName(String idpConfigName) {
        if (idpConfigName == null) {
            throw new NullPointerException("idpConfigName should never be null");
        }
        this.idpConfigName = idpConfigName;
    }

    public SAMLConfigImpl withIdpConfigName(String idpConfigName) {
        this.setIdpConfigName(idpConfigName);
        return this;
    }

    public String getSpConfigName() {
        return this.spConfigName;
    }

    public void setSpConfigName(String spConfigName) {
        if (spConfigName == null) {
            throw new NullPointerException("spConfigName should never be null");
        }
        this.spConfigName = spConfigName;
    }

    public SAMLConfigImpl withSpConfigName(String spConfigName) {
        this.setSpConfigName(spConfigName);
        return this;
    }

    public SAMLConfigImpl init(Function<String, String> function) throws SAMLException {
        String fileName;
        SAMLInit.initialize();
        if (this.keystore == null) {
            fileName = function.apply(this.getKeystoreName());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("%s: %s", "KeystoreName", fileName));
            }
            this.keystore = new File(fileName);
        }
        if (this.idpConfig == null) {
            fileName = function.apply(this.getIdpConfigName());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("%s: %s", "IdpConfigName", fileName));
            }
            this.idpConfig = new IdPConfig(new File(fileName));
        }
        if (this.spConfig == null) {
            fileName = function.apply(this.getSpConfigName());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("%s: %s", "SpConfigName", fileName));
            }
            this.spConfig = new SPConfig(new File(fileName));
        }
        return this;
    }

    public SAMLConfigImpl init() throws SAMLException {
        return this.init(filename -> filename);
    }
}

