/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.jmx.addons.kannel;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.adeptnet.jmx.addons.kannel.Bean;
import org.adeptnet.jmx.addons.kannel.BeanInterface;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private MBeanServer mbs = null;
    private ObjectName name = null;

    public String getObjectName(BeanInterface bean) {
        return String.format("%s:type=%s,name=%s", bean.getClass().getPackage().getName(), bean.getClass().getSimpleName(), "bean");
    }

    public void start(BundleContext context) throws Exception {
        LOG.log(Level.INFO, "ADEPTNET Starting: {0}", Activator.class);
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        Bean bean = new Bean();
        this.name = new ObjectName(this.getObjectName(bean));
        StandardMBean mbean = new StandardMBean(bean, BeanInterface.class, true);
        this.mbs.registerMBean(mbean, this.name);
        LOG.log(Level.INFO, "ADEPTNET Started: {0}", Activator.class);
    }

    public void stop(BundleContext context) throws Exception {
        LOG.log(Level.INFO, "ADEPTNET Stopping: {0}", Activator.class);
        if (this.name != null) {
            this.mbs.unregisterMBean(this.name);
        }
        LOG.log(Level.INFO, "ADEPTNET Stopped: {0}", Activator.class);
    }
}

