/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.jmx.addons.snmp;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.jmx.addons.snmp.Activator;
import org.adeptnet.jmx.addons.snmp.BeanInterface;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Bean
implements BeanInterface {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private PDU pdu;
    private final CamelContext context;

    public Bean(CamelContext context) {
        this.context = context;
    }

    @Override
    public void loadFromURL(String url) throws IOException {
        this.loadFromURLInternal(url, false);
    }

    @Override
    public void loadFromURLDebug(String url) throws IOException {
        this.loadFromURLInternal(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromURLInternal(String url, boolean debug) throws IOException {
        DefaultTcpTransportMapping transport;
        this.pdu = null;
        Endpoint _endpoint = this.context.getEndpoint(url);
        if (!(_endpoint instanceof SnmpEndpoint)) {
            throw new IllegalArgumentException("Unknown SnmpEndpoint: " + _endpoint.getClass());
        }
        SnmpEndpoint endpoint = (SnmpEndpoint)_endpoint;
        Address targetAddress = GenericAddress.parse((String)endpoint.getAddress());
        if ("tcp".equals(endpoint.getProtocol())) {
            transport = new DefaultTcpTransportMapping();
        } else if ("udp".equals(endpoint.getProtocol())) {
            transport = new DefaultUdpTransportMapping();
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + endpoint.getProtocol());
        }
        try {
            Snmp snmp = new Snmp((TransportMapping)transport);
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(endpoint.getSnmpCommunity()));
            target.setAddress(targetAddress);
            target.setRetries(endpoint.getRetries());
            target.setTimeout((long)endpoint.getTimeout());
            target.setVersion(endpoint.getSnmpVersion());
            PDU _pdu = new PDU();
            _pdu.clear();
            _pdu.setType(-96);
            for (OID oid : endpoint.getOids()) {
                _pdu.add(new VariableBinding(oid));
            }
            transport.listen();
            ResponseEvent event = snmp.send(_pdu, (Target)target, null);
            this.pdu = event.getResponse();
            if (debug) {
                LOG.log(Level.INFO, MessageFormat.format("URL: {0} Map: {1}", url, this.asMap()));
            }
        }
        finally {
            transport.close();
        }
    }

    @Override
    public String asString(String oid) {
        if (this.pdu == null) {
            throw new NullPointerException("pdu is NULL, call loadFromURL()");
        }
        return this.pdu.getVariable(new OID(oid)).toString();
    }

    @Override
    public int asInt(String oid) {
        if (this.pdu == null) {
            throw new NullPointerException("pdu is NULL, call loadFromURL()");
        }
        return this.pdu.getVariable(new OID(oid)).toInt();
    }

    @Override
    public long asLong(String oid) {
        if (this.pdu == null) {
            throw new NullPointerException("pdu is NULL, call loadFromURL()");
        }
        return this.pdu.getVariable(new OID(oid)).toLong();
    }

    @Override
    public Map<String, String> asMap() {
        if (this.pdu == null) {
            throw new NullPointerException("pdu is NULL, call loadFromURL()");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (VariableBinding vb : this.pdu.toArray()) {
            map.put(vb.getOid().toString(), vb.getVariable().toString());
        }
        return map;
    }
}

