/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.jmx.addons.snmp;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.adeptnet.jmx.addons.snmp.Bean;
import org.adeptnet.jmx.addons.snmp.BeanInterface;
import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private Bean bean;
    private MBeanServer mbs = null;
    private ObjectName name = null;

    public String getObjectName(BeanInterface bean) {
        return String.format("%s:type=%s,name=%s", bean.getClass().getPackage().getName(), bean.getClass().getSimpleName(), "bean");
    }

    public void start(BundleContext context) throws Exception {
        LOG.log(Level.INFO, "ADEPTNET Starting: {0}", Activator.class);
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.bean = new Bean((CamelContext)new OsgiDefaultCamelContext(context));
        this.bean.start();
        this.name = new ObjectName(this.getObjectName(this.bean));
        StandardMBean mbean = new StandardMBean(this.bean, BeanInterface.class, true);
        this.mbs.registerMBean(mbean, this.name);
        LOG.log(Level.INFO, "ADEPTNET Started: {0}", Activator.class);
    }

    public void stop(BundleContext context) throws Exception {
        LOG.log(Level.INFO, "ADEPTNET Stopping: {0}", Activator.class);
        this.bean.stop();
        if (this.name != null) {
            this.mbs.unregisterMBean(this.name);
        }
        LOG.log(Level.INFO, "ADEPTNET Stopped: {0}", Activator.class);
    }
}

