/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.jmx.addons.snmp;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.jmx.addons.snmp.BeanInterface;
import org.adeptnet.jmx.addons.snmp.BeanPDU;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Bean
implements BeanInterface {
    private static final Logger LOG = Logger.getLogger(Bean.class.getName());
    private static final BeanPDU pdus = new BeanPDU();
    private final CamelContext context;
    private final MapThread mapThread;
    private final Thread thread;

    public Bean(CamelContext context) {
        this.context = context;
        this.mapThread = new MapThread();
        this.thread = new Thread(this.mapThread);
        this.thread.setDaemon(true);
        this.mapThread.setRunning(true);
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.mapThread.setRunning(false);
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanPDU.Record getBeanPDU(String reference) {
        BeanPDU beanPDU = pdus;
        synchronized (beanPDU) {
            if (!pdus.hasRecord(reference)) {
                throw new NullPointerException("pdu is NULL, call loadFromURL()");
            }
            return pdus.getRecord(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBeanPDU(String reference, PDU pdu) {
        BeanPDU beanPDU = pdus;
        synchronized (beanPDU) {
            pdus.setRecord(reference, pdu);
        }
    }

    @Override
    public void loadFromURL(String reference, String url) throws IOException {
        this.loadFromURLInternal(reference, url, false);
    }

    @Override
    public void loadFromURLDebug(String reference, String url) throws IOException {
        this.loadFromURLInternal(reference, url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromURLInternal(String reference, String url, boolean debug) throws IOException {
        DefaultTcpTransportMapping transport;
        Endpoint _endpoint = this.context.getEndpoint(url);
        if (!(_endpoint instanceof SnmpEndpoint)) {
            throw new IllegalArgumentException("Unknown SnmpEndpoint: " + _endpoint.getClass());
        }
        SnmpEndpoint endpoint = (SnmpEndpoint)_endpoint;
        Address targetAddress = GenericAddress.parse((String)endpoint.getAddress());
        if ("tcp".equals(endpoint.getProtocol())) {
            transport = new DefaultTcpTransportMapping();
        } else if ("udp".equals(endpoint.getProtocol())) {
            transport = new DefaultUdpTransportMapping();
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + endpoint.getProtocol());
        }
        try {
            Snmp snmp = new Snmp((TransportMapping)transport);
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(endpoint.getSnmpCommunity()));
            target.setAddress(targetAddress);
            target.setRetries(endpoint.getRetries());
            target.setTimeout((long)endpoint.getTimeout());
            target.setVersion(endpoint.getSnmpVersion());
            PDU _pdu = new PDU();
            _pdu.clear();
            _pdu.setType(-96);
            for (OID oid : endpoint.getOids()) {
                _pdu.add(new VariableBinding(oid));
            }
            transport.listen();
            ResponseEvent event = snmp.send(_pdu, (Target)target, null);
            this.setBeanPDU(reference, event.getResponse());
            if (debug) {
                LOG.log(Level.INFO, MessageFormat.format("Reference: {0}, URL: {1} ", reference, url));
                LOG.log(Level.INFO, MessageFormat.format("Map: {0}", this.asMap(reference)));
            }
        }
        finally {
            transport.close();
        }
    }

    @Override
    public String asString(String reference, String oid) {
        return this.getBeanPDU(reference).getPdu().getVariable(new OID(oid)).toString();
    }

    @Override
    public int asInt(String reference, String oid) {
        return this.getBeanPDU(reference).getPdu().getVariable(new OID(oid)).toInt();
    }

    @Override
    public long asLong(String reference, String oid) {
        return this.getBeanPDU(reference).getPdu().getVariable(new OID(oid)).toLong();
    }

    @Override
    public Map<String, String> asMap(String reference) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (VariableBinding vb : this.getBeanPDU(reference).getPdu().toArray()) {
            map.put(vb.getOid().toString(), vb.getVariable().toString());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupData(String fromReference, String toReference) {
        BeanPDU beanPDU = pdus;
        synchronized (beanPDU) {
            if (!pdus.hasRecord(fromReference)) {
                return;
            }
            pdus.setRecord(toReference, pdus.getRecord(fromReference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long backupCreatedDiff(String fromReference, String toReference) {
        BeanPDU beanPDU = pdus;
        synchronized (beanPDU) {
            if (!pdus.hasRecord(fromReference)) {
                return 0L;
            }
            if (!pdus.hasRecord(toReference)) {
                return 0L;
            }
            return pdus.getRecord(fromReference).getCreated() - pdus.getRecord(toReference).getCreated();
        }
    }

    public static class MapThread
    implements Runnable {
        private boolean running;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    while (this.isRunning()) {
                        BeanPDU beanPDU = pdus;
                        synchronized (beanPDU) {
                            long current = System.currentTimeMillis();
                            LOG.log(Level.FINE, "mapThread Running: {0}", pdus.getMap().size());
                            Iterator<String> keys = pdus.getMap().keySet().iterator();
                            while (keys.hasNext()) {
                                String key = keys.next();
                                BeanPDU.Record record = pdus.getMap().get(key);
                                long lastUsed = current - record.getLastUsed();
                                if (lastUsed <= 1800000L) continue;
                                LOG.log(Level.INFO, "Removing old Reference: {0}", key);
                                keys.remove();
                            }
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException ex) {
                    if (!this.isRunning()) break block7;
                    LOG.log(Level.SEVERE, "mapThread", ex);
                }
            }
        }
    }
}

