/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.jmx.addons.snmp;

import java.util.HashMap;
import java.util.Map;
import org.snmp4j.PDU;

public class BeanPDU {
    private final Map<String, Record> pdus = new HashMap<String, Record>();

    protected Map<String, Record> getMap() {
        return this.pdus;
    }

    public boolean hasRecord(String reference) {
        return this.pdus.containsKey(reference);
    }

    public Record getRecord(String reference) {
        return this.pdus.get(reference).withLastUsed();
    }

    public void setRecord(String reference, PDU pdu) {
        Record record = new Record(pdu).withLastUsed();
        this.pdus.put(reference, record);
    }

    public void setRecord(String reference, Record record) {
        Record r = new Record(record.getPdu(), record.getCreated()).withLastUsed();
        this.pdus.put(reference, r);
    }

    public class Record {
        private final PDU pdu;
        private long lastUsed = 0L;
        private final long created;

        public Record(PDU pdu, long created) {
            this.pdu = pdu;
            this.created = created;
        }

        public Record(PDU pdu) {
            this(pdu, System.currentTimeMillis());
        }

        public PDU getPdu() {
            return this.pdu;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public Record withLastUsed() {
            this.lastUsed = System.currentTimeMillis();
            return this;
        }

        public long getCreated() {
            return this.created;
        }
    }
}

