/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.servlet.osgi;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.adeptnet.prtg.config.ConfigInterface;
import org.adeptnet.prtg.config.SensorProcess;
import org.adeptnet.prtg.config.xml.SensorType;
import org.adeptnet.prtg.servlet.osgi.Activator;

public class Servlet
extends HttpServlet {
    private static final long serialVersionUID = 20140101001L;
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private final ConfigInterface configInterface;

    public Servlet(ConfigInterface configInterface) {
        this.configInterface = configInterface;
    }

    private String getHelp() throws JAXBException {
        StringBuilder sb = new StringBuilder();
        for (SensorType sensor : this.configInterface.getConfig().getSensors()) {
            sb.append(String.format("URI: prtg?name=%s\n", sensor.getName()));
        }
        return sb.toString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.info(String.format("doGet: %s ServletPath [%s] PathInfo [%s] QueryString [%s]", request.getRemoteHost(), request.getServletPath(), request.getPathInfo(), request.getQueryString()));
        try {
            if (request.getPathInfo() == null) {
                response.getWriter().write(this.getHelp());
            } else {
                switch (request.getPathInfo()) {
                    case "/prtg": {
                        response.getWriter().write(new SensorProcess(this.configInterface).withSensorName(request.getParameter("name")).run());
                        break;
                    }
                    default: {
                        response.getWriter().write(this.getHelp());
                    }
                }
            }
        }
        catch (JAXBException ex) {
            LOG.log(Level.SEVERE, String.format("JaxbManager.toXML1: ServletPath [%s] PathInfo [%s] QueryString [%s]", request.getServletPath(), request.getPathInfo(), request.getQueryString()));
            LOG.log(Level.SEVERE, String.format("JaxbManager.toXML2: %s", ex.getMessage()), ex);
            response.setContentType("text/plain");
            response.sendError(500, ex.getMessage());
        }
    }
}

