/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.servlet.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.prtg.config.ConfigInterface;
import org.adeptnet.prtg.config.SensorException;
import org.adeptnet.prtg.config.impl.ConfigImplementation;
import org.adeptnet.prtg.servlet.osgi.JaxbManager;
import org.adeptnet.prtg.servlet.osgi.Servlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private static final String PREFIX = "org.adeptnet";
    private static final String CONFIG_PATH = "org.adeptnet.config.path";
    private static final String CONFIG_FILE = "org.adeptnet.cfg";
    private static final String OSGI_PREFIX = "org.adeptnet.prtg.servlet.osgi";
    private static final String CONFIG = "org.adeptnet.prtg.servlet.osgi.config";
    private static final String ALIAS = "org.adeptnet.prtg.servlet.osgi.alias";
    private ServiceRegistration registration;
    private String path;
    private Properties properties;

    private Properties getProperties() throws SensorException {
        if (this.properties == null) {
            try {
                File file = new File(this.path + "/" + CONFIG_FILE);
                FileInputStream is = new FileInputStream(file);
                this.properties = new Properties();
                this.properties.load(is);
            }
            catch (IOException ex) {
                throw new SensorException("getProperties(): " + ex.getMessage(), (Throwable)ex);
            }
        }
        return this.properties;
    }

    private String getProperty(String name) throws SensorException {
        String result = this.getProperties().getProperty(name);
        if (result == null) {
            throw new SensorException(String.format("getProperty(): %s is null", name));
        }
        return result;
    }

    public void start(BundleContext context) {
        try {
            LOG.log(Level.INFO, "ADEPTNET Starting: {0}", Activator.class);
            this.path = System.getProperty(CONFIG_PATH);
            if (this.path == null) {
                throw new SensorException(String.format("%s is null", CONFIG_PATH));
            }
            Servlet servlet = new Servlet((ConfigInterface)new ConfigImplementation((org.adeptnet.prtg.config.xml.JaxbManager)new JaxbManager(context.getBundle())).withXml(this.getProperty(CONFIG)));
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("alias", this.getProperty(ALIAS));
            this.registration = context.registerService(javax.servlet.Servlet.class.getName(), (Object)servlet, props);
            LOG.log(Level.INFO, "ADEPTNET Started: {0}", Activator.class);
        }
        catch (SensorException ex) {
            LOG.log(Level.SEVERE, "Cannot Start Activator: " + ex.getMessage(), ex);
        }
    }

    public void stop(BundleContext context) {
        LOG.log(Level.INFO, "ADEPTNET Stopping: {0}", Activator.class);
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

