
package org.adeptnet.prtg.xml;

import java.io.Serializable;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for ChannelType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ChannelType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="channel" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *         &lt;element name="value" type="{urn:ietf:params:xml:ns:prtg-1.0}ValuePattern"/>
 *         &lt;choice>
 *           &lt;element name="unit" type="{urn:ietf:params:xml:ns:prtg-1.0}UnitType"/>
 *           &lt;element name="customunit" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *           &lt;element name="speedsize" type="{urn:ietf:params:xml:ns:prtg-1.0}UnitSizeType"/>
 *           &lt;element name="volumesize" type="{urn:ietf:params:xml:ns:prtg-1.0}UnitSizeType"/>
 *           &lt;element name="speedtime" type="{urn:ietf:params:xml:ns:prtg-1.0}TimeType"/>
 *           &lt;element name="mode" type="{urn:ietf:params:xml:ns:prtg-1.0}ModeType"/>
 *           &lt;element name="float" type="{urn:ietf:params:xml:ns:prtg-1.0}BooleanType"/>
 *           &lt;element name="decimalmode" type="{urn:ietf:params:xml:ns:prtg-1.0}DecimalModeType"/>
 *           &lt;element name="warning" type="{urn:ietf:params:xml:ns:prtg-1.0}BooleanType"/>
 *           &lt;element name="showchart" type="{urn:ietf:params:xml:ns:prtg-1.0}BooleanType"/>
 *           &lt;element name="showtable" type="{urn:ietf:params:xml:ns:prtg-1.0}BooleanType"/>
 *           &lt;element name="limitmaxerror" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *           &lt;element name="limitmaxwarning" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *           &lt;element name="limitminwarning" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *           &lt;element name="limitminerror" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *           &lt;element name="limiterrormsg" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *           &lt;element name="limitwarningmsg" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *           &lt;element name="limitmode" type="{urn:ietf:params:xml:ns:prtg-1.0}BooleanType"/>
 *           &lt;element name="valuelookup" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ChannelType", namespace = "urn:ietf:params:xml:ns:prtg-1.0", propOrder = {
    "name",
    "value",
    "unit",
    "customUnit",
    "speedSize",
    "volumeSize",
    "speedTime",
    "mode",
    "_float",
    "decimalMode",
    "warning",
    "showChart",
    "showtable",
    "limitMaxError",
    "limitMaxWarning",
    "limitMinWarning",
    "limitMinError",
    "limitErrorMessage",
    "limitWarningMessage",
    "limitMode",
    "valueLookup"
})
public class ChannelType
    implements Serializable, Cloneable, CopyTo, ToString
{

    private final static long serialVersionUID = 201401010001L;
    @XmlElement(name = "channel", namespace = "urn:ietf:params:xml:ns:prtg-1.0", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String name;
    @XmlElement(namespace = "urn:ietf:params:xml:ns:prtg-1.0", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String value;
    @XmlElement(namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected UnitType unit;
    @XmlElement(name = "customunit", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String customUnit;
    @XmlElement(name = "speedsize", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected UnitSizeType speedSize;
    @XmlElement(name = "volumesize", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected UnitSizeType volumeSize;
    @XmlElement(name = "speedtime", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected TimeType speedTime;
    @XmlElement(namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected ModeType mode;
    @XmlElement(name = "float", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BooleanType _float;
    @XmlElement(name = "decimalmode", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected DecimalModeType decimalMode;
    @XmlElement(namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BooleanType warning;
    @XmlElement(name = "showchart", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BooleanType showChart;
    @XmlElement(namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BooleanType showtable;
    @XmlElement(name = "limitmaxerror", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BigInteger limitMaxError;
    @XmlElement(name = "limitmaxwarning", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BigInteger limitMaxWarning;
    @XmlElement(name = "limitminwarning", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BigInteger limitMinWarning;
    @XmlElement(name = "limitminerror", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BigInteger limitMinError;
    @XmlElement(name = "limiterrormsg", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String limitErrorMessage;
    @XmlElement(name = "limitwarningmsg", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String limitWarningMessage;
    @XmlElement(name = "limitmode", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    protected BooleanType limitMode;
    @XmlElement(name = "valuelookup", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String valueLookup;

    /**
     * Name of the channel as displayed in user interfaces. This parameter is required and must be unique for the sensor.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * The value as integer or float. Please make sure the &lt;Float&gt; setting matches the kind of value provided. Otherwise PRTG will show 0 values.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * The unit of the value. Default is Custom. Useful for PRTG to be able to convert volumes and times.
     * 
     * @return
     *     possible object is
     *     {@link UnitType }
     *     
     */
    public UnitType getUnit() {
        return unit;
    }

    /**
     * Sets the value of the unit property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnitType }
     *     
     */
    public void setUnit(UnitType value) {
        this.unit = value;
    }

    public boolean isSetUnit() {
        return (this.unit!= null);
    }

    /**
     * If Custom is used as unit this is the text displayed behind the value.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomUnit() {
        return customUnit;
    }

    /**
     * Sets the value of the customUnit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomUnit(String value) {
        this.customUnit = value;
    }

    public boolean isSetCustomUnit() {
        return (this.customUnit!= null);
    }

    /**
     * Size used for the display value. E.g. if you have a value of 50000 and use Kilo as size the display is 50 kilo #. Default is One (value used as returned). For the Bytes and Speed units this is overridden by the setting in the user interface.
     * 
     * @return
     *     possible object is
     *     {@link UnitSizeType }
     *     
     */
    public UnitSizeType getSpeedSize() {
        return speedSize;
    }

    /**
     * Sets the value of the speedSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnitSizeType }
     *     
     */
    public void setSpeedSize(UnitSizeType value) {
        this.speedSize = value;
    }

    public boolean isSetSpeedSize() {
        return (this.speedSize!= null);
    }

    /**
     * Size used for the display value. E.g. if you have a value of 50000 and use Kilo as size the display is 50 kilo #. Default is One (value used as returned). For the Bytes and Speed units this is overridden by the setting in the user interface.
     * 
     * @return
     *     possible object is
     *     {@link UnitSizeType }
     *     
     */
    public UnitSizeType getVolumeSize() {
        return volumeSize;
    }

    /**
     * Sets the value of the volumeSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnitSizeType }
     *     
     */
    public void setVolumeSize(UnitSizeType value) {
        this.volumeSize = value;
    }

    public boolean isSetVolumeSize() {
        return (this.volumeSize!= null);
    }

    /**
     * See above, used when displaying the speed. Default is Second.
     * 
     * @return
     *     possible object is
     *     {@link TimeType }
     *     
     */
    public TimeType getSpeedTime() {
        return speedTime;
    }

    /**
     * Sets the value of the speedTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeType }
     *     
     */
    public void setSpeedTime(TimeType value) {
        this.speedTime = value;
    }

    public boolean isSetSpeedTime() {
        return (this.speedTime!= null);
    }

    /**
     * Selects if the value is a absolut value or counter. Default is Absolute.
     * 
     * @return
     *     possible object is
     *     {@link ModeType }
     *     
     */
    public ModeType getMode() {
        return mode;
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModeType }
     *     
     */
    public void setMode(ModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

    /**
     * Define if the value is a float. Default is 0 (no). If set to 1 (yes), use a dot as decimal seperator in values. Note: Define decimal places with the &lt;DecimalMode&gt; element.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getFloat() {
        return _float;
    }

    /**
     * Sets the value of the float property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setFloat(BooleanType value) {
        this._float = value;
    }

    public boolean isSetFloat() {
        return (this._float!= null);
    }

    /**
     * Init value for the Decimal Places option. If 0 is used in the &lt;Float&gt; element (i.e. use integer), the default is Auto; otherwise (i.e. for float) default is All. Note: In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link DecimalModeType }
     *     
     */
    public DecimalModeType getDecimalMode() {
        return decimalMode;
    }

    /**
     * Sets the value of the decimalMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DecimalModeType }
     *     
     */
    public void setDecimalMode(DecimalModeType value) {
        this.decimalMode = value;
    }

    public boolean isSetDecimalMode() {
        return (this.decimalMode!= null);
    }

    /**
     * If enabled for at least one channel, the entire sensor is set to warning status. Default is 0 (no).
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getWarning() {
        return warning;
    }

    /**
     * Sets the value of the warning property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setWarning(BooleanType value) {
        this.warning = value;
    }

    public boolean isSetWarning() {
        return (this.warning!= null);
    }

    /**
     * Init value for the Show in Chart option. Default is 1 (yes). Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getShowChart() {
        return showChart;
    }

    /**
     * Sets the value of the showChart property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setShowChart(BooleanType value) {
        this.showChart = value;
    }

    public boolean isSetShowChart() {
        return (this.showChart!= null);
    }

    /**
     * Init value for the Show in Table option. Default is 1 (yes). Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getShowtable() {
        return showtable;
    }

    /**
     * Sets the value of the showtable property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setShowtable(BooleanType value) {
        this.showtable = value;
    }

    public boolean isSetShowtable() {
        return (this.showtable!= null);
    }

    /**
     * Define an upper error limit for the channel. If enabled, the sensor will be set to a "Down" status if this value is overrun and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. While a sensor shows a "Down" status triggered by a limit, it will still receive data in its channels. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMaxError() {
        return limitMaxError;
    }

    /**
     * Sets the value of the limitMaxError property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMaxError(BigInteger value) {
        this.limitMaxError = value;
    }

    public boolean isSetLimitMaxError() {
        return (this.limitMaxError!= null);
    }

    /**
     * Define an upper warning limit for the channel. If enabled, the sensor will be set to a "Warning" status if this value is overrun and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMaxWarning() {
        return limitMaxWarning;
    }

    /**
     * Sets the value of the limitMaxWarning property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMaxWarning(BigInteger value) {
        this.limitMaxWarning = value;
    }

    public boolean isSetLimitMaxWarning() {
        return (this.limitMaxWarning!= null);
    }

    /**
     * Define a lower warning limit for the channel. If enabled, the sensor will be set to a "Warning" status if this value is undercut and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMinWarning() {
        return limitMinWarning;
    }

    /**
     * Sets the value of the limitMinWarning property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMinWarning(BigInteger value) {
        this.limitMinWarning = value;
    }

    public boolean isSetLimitMinWarning() {
        return (this.limitMinWarning!= null);
    }

    /**
     * Define a lower error limit for the channel. If enabled, the sensor will be set to a "Down" status if this value is undercut and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. While a sensor shows a "Down" status triggered by a limit, it will still receive data in its channels. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMinError() {
        return limitMinError;
    }

    /**
     * Sets the value of the limitMinError property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMinError(BigInteger value) {
        this.limitMinError = value;
    }

    public boolean isSetLimitMinError() {
        return (this.limitMinError!= null);
    }

    /**
     * Define an additional message. It will be added to the sensor's message when entering a "Down" status that is triggered by a limit. Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLimitErrorMessage() {
        return limitErrorMessage;
    }

    /**
     * Sets the value of the limitErrorMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLimitErrorMessage(String value) {
        this.limitErrorMessage = value;
    }

    public boolean isSetLimitErrorMessage() {
        return (this.limitErrorMessage!= null);
    }

    /**
     * Define an additional message. It will be added to the sensor's message when entering a "Warning" status that is triggered by a limit. Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLimitWarningMessage() {
        return limitWarningMessage;
    }

    /**
     * Sets the value of the limitWarningMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLimitWarningMessage(String value) {
        this.limitWarningMessage = value;
    }

    public boolean isSetLimitWarningMessage() {
        return (this.limitWarningMessage!= null);
    }

    /**
     * Define if the limit settings defined above will be active. Default is 0 (no; limits inactive). If 0 is used the limits will be written to the sensor channel settings as predefined values, but limits will be disabled. Note: This setting will be considered only on the first sensor scan, when the channel is newly created; it is ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getLimitMode() {
        return limitMode;
    }

    /**
     * Sets the value of the limitMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setLimitMode(BooleanType value) {
        this.limitMode = value;
    }

    public boolean isSetLimitMode() {
        return (this.limitMode!= null);
    }

    /**
     * Define if you want to use a lookup file (e.g. to view integer values as status texts). Please enter the ID of the lookup file you want to use, or omit this element to not use lookups. Note: This setting will be considered only on the first sensor scan, when the channel is newly created; it is ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValueLookup() {
        return valueLookup;
    }

    /**
     * Sets the value of the valueLookup property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValueLookup(String value) {
        this.valueLookup = value;
    }

    public boolean isSetValueLookup() {
        return (this.valueLookup!= null);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName);
        }
        {
            String theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue);
        }
        {
            UnitType theUnit;
            theUnit = this.getUnit();
            strategy.appendField(locator, this, "unit", buffer, theUnit);
        }
        {
            String theCustomUnit;
            theCustomUnit = this.getCustomUnit();
            strategy.appendField(locator, this, "customUnit", buffer, theCustomUnit);
        }
        {
            UnitSizeType theSpeedSize;
            theSpeedSize = this.getSpeedSize();
            strategy.appendField(locator, this, "speedSize", buffer, theSpeedSize);
        }
        {
            UnitSizeType theVolumeSize;
            theVolumeSize = this.getVolumeSize();
            strategy.appendField(locator, this, "volumeSize", buffer, theVolumeSize);
        }
        {
            TimeType theSpeedTime;
            theSpeedTime = this.getSpeedTime();
            strategy.appendField(locator, this, "speedTime", buffer, theSpeedTime);
        }
        {
            ModeType theMode;
            theMode = this.getMode();
            strategy.appendField(locator, this, "mode", buffer, theMode);
        }
        {
            BooleanType theFloat;
            theFloat = this.getFloat();
            strategy.appendField(locator, this, "_float", buffer, theFloat);
        }
        {
            DecimalModeType theDecimalMode;
            theDecimalMode = this.getDecimalMode();
            strategy.appendField(locator, this, "decimalMode", buffer, theDecimalMode);
        }
        {
            BooleanType theWarning;
            theWarning = this.getWarning();
            strategy.appendField(locator, this, "warning", buffer, theWarning);
        }
        {
            BooleanType theShowChart;
            theShowChart = this.getShowChart();
            strategy.appendField(locator, this, "showChart", buffer, theShowChart);
        }
        {
            BooleanType theShowtable;
            theShowtable = this.getShowtable();
            strategy.appendField(locator, this, "showtable", buffer, theShowtable);
        }
        {
            BigInteger theLimitMaxError;
            theLimitMaxError = this.getLimitMaxError();
            strategy.appendField(locator, this, "limitMaxError", buffer, theLimitMaxError);
        }
        {
            BigInteger theLimitMaxWarning;
            theLimitMaxWarning = this.getLimitMaxWarning();
            strategy.appendField(locator, this, "limitMaxWarning", buffer, theLimitMaxWarning);
        }
        {
            BigInteger theLimitMinWarning;
            theLimitMinWarning = this.getLimitMinWarning();
            strategy.appendField(locator, this, "limitMinWarning", buffer, theLimitMinWarning);
        }
        {
            BigInteger theLimitMinError;
            theLimitMinError = this.getLimitMinError();
            strategy.appendField(locator, this, "limitMinError", buffer, theLimitMinError);
        }
        {
            String theLimitErrorMessage;
            theLimitErrorMessage = this.getLimitErrorMessage();
            strategy.appendField(locator, this, "limitErrorMessage", buffer, theLimitErrorMessage);
        }
        {
            String theLimitWarningMessage;
            theLimitWarningMessage = this.getLimitWarningMessage();
            strategy.appendField(locator, this, "limitWarningMessage", buffer, theLimitWarningMessage);
        }
        {
            BooleanType theLimitMode;
            theLimitMode = this.getLimitMode();
            strategy.appendField(locator, this, "limitMode", buffer, theLimitMode);
        }
        {
            String theValueLookup;
            theValueLookup = this.getValueLookup();
            strategy.appendField(locator, this, "valueLookup", buffer, theValueLookup);
        }
        return buffer;
    }

    public ChannelType withName(String value) {
        setName(value);
        return this;
    }

    public ChannelType withValue(String value) {
        setValue(value);
        return this;
    }

    public ChannelType withUnit(UnitType value) {
        setUnit(value);
        return this;
    }

    public ChannelType withCustomUnit(String value) {
        setCustomUnit(value);
        return this;
    }

    public ChannelType withSpeedSize(UnitSizeType value) {
        setSpeedSize(value);
        return this;
    }

    public ChannelType withVolumeSize(UnitSizeType value) {
        setVolumeSize(value);
        return this;
    }

    public ChannelType withSpeedTime(TimeType value) {
        setSpeedTime(value);
        return this;
    }

    public ChannelType withMode(ModeType value) {
        setMode(value);
        return this;
    }

    public ChannelType withFloat(BooleanType value) {
        setFloat(value);
        return this;
    }

    public ChannelType withDecimalMode(DecimalModeType value) {
        setDecimalMode(value);
        return this;
    }

    public ChannelType withWarning(BooleanType value) {
        setWarning(value);
        return this;
    }

    public ChannelType withShowChart(BooleanType value) {
        setShowChart(value);
        return this;
    }

    public ChannelType withShowtable(BooleanType value) {
        setShowtable(value);
        return this;
    }

    public ChannelType withLimitMaxError(BigInteger value) {
        setLimitMaxError(value);
        return this;
    }

    public ChannelType withLimitMaxWarning(BigInteger value) {
        setLimitMaxWarning(value);
        return this;
    }

    public ChannelType withLimitMinWarning(BigInteger value) {
        setLimitMinWarning(value);
        return this;
    }

    public ChannelType withLimitMinError(BigInteger value) {
        setLimitMinError(value);
        return this;
    }

    public ChannelType withLimitErrorMessage(String value) {
        setLimitErrorMessage(value);
        return this;
    }

    public ChannelType withLimitWarningMessage(String value) {
        setLimitWarningMessage(value);
        return this;
    }

    public ChannelType withLimitMode(BooleanType value) {
        setLimitMode(value);
        return this;
    }

    public ChannelType withValueLookup(String value) {
        setValueLookup(value);
        return this;
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof ChannelType) {
            final ChannelType copy = ((ChannelType) draftCopy);
            if (this.isSetName()) {
                String sourceName;
                sourceName = this.getName();
                String copyName = ((String) strategy.copy(LocatorUtils.property(locator, "name", sourceName), sourceName));
                copy.setName(copyName);
            } else {
                copy.name = null;
            }
            if (this.isSetValue()) {
                String sourceValue;
                sourceValue = this.getValue();
                String copyValue = ((String) strategy.copy(LocatorUtils.property(locator, "value", sourceValue), sourceValue));
                copy.setValue(copyValue);
            } else {
                copy.value = null;
            }
            if (this.isSetUnit()) {
                UnitType sourceUnit;
                sourceUnit = this.getUnit();
                UnitType copyUnit = ((UnitType) strategy.copy(LocatorUtils.property(locator, "unit", sourceUnit), sourceUnit));
                copy.setUnit(copyUnit);
            } else {
                copy.unit = null;
            }
            if (this.isSetCustomUnit()) {
                String sourceCustomUnit;
                sourceCustomUnit = this.getCustomUnit();
                String copyCustomUnit = ((String) strategy.copy(LocatorUtils.property(locator, "customUnit", sourceCustomUnit), sourceCustomUnit));
                copy.setCustomUnit(copyCustomUnit);
            } else {
                copy.customUnit = null;
            }
            if (this.isSetSpeedSize()) {
                UnitSizeType sourceSpeedSize;
                sourceSpeedSize = this.getSpeedSize();
                UnitSizeType copySpeedSize = ((UnitSizeType) strategy.copy(LocatorUtils.property(locator, "speedSize", sourceSpeedSize), sourceSpeedSize));
                copy.setSpeedSize(copySpeedSize);
            } else {
                copy.speedSize = null;
            }
            if (this.isSetVolumeSize()) {
                UnitSizeType sourceVolumeSize;
                sourceVolumeSize = this.getVolumeSize();
                UnitSizeType copyVolumeSize = ((UnitSizeType) strategy.copy(LocatorUtils.property(locator, "volumeSize", sourceVolumeSize), sourceVolumeSize));
                copy.setVolumeSize(copyVolumeSize);
            } else {
                copy.volumeSize = null;
            }
            if (this.isSetSpeedTime()) {
                TimeType sourceSpeedTime;
                sourceSpeedTime = this.getSpeedTime();
                TimeType copySpeedTime = ((TimeType) strategy.copy(LocatorUtils.property(locator, "speedTime", sourceSpeedTime), sourceSpeedTime));
                copy.setSpeedTime(copySpeedTime);
            } else {
                copy.speedTime = null;
            }
            if (this.isSetMode()) {
                ModeType sourceMode;
                sourceMode = this.getMode();
                ModeType copyMode = ((ModeType) strategy.copy(LocatorUtils.property(locator, "mode", sourceMode), sourceMode));
                copy.setMode(copyMode);
            } else {
                copy.mode = null;
            }
            if (this.isSetFloat()) {
                BooleanType sourceFloat;
                sourceFloat = this.getFloat();
                BooleanType copyFloat = ((BooleanType) strategy.copy(LocatorUtils.property(locator, "_float", sourceFloat), sourceFloat));
                copy.setFloat(copyFloat);
            } else {
                copy._float = null;
            }
            if (this.isSetDecimalMode()) {
                DecimalModeType sourceDecimalMode;
                sourceDecimalMode = this.getDecimalMode();
                DecimalModeType copyDecimalMode = ((DecimalModeType) strategy.copy(LocatorUtils.property(locator, "decimalMode", sourceDecimalMode), sourceDecimalMode));
                copy.setDecimalMode(copyDecimalMode);
            } else {
                copy.decimalMode = null;
            }
            if (this.isSetWarning()) {
                BooleanType sourceWarning;
                sourceWarning = this.getWarning();
                BooleanType copyWarning = ((BooleanType) strategy.copy(LocatorUtils.property(locator, "warning", sourceWarning), sourceWarning));
                copy.setWarning(copyWarning);
            } else {
                copy.warning = null;
            }
            if (this.isSetShowChart()) {
                BooleanType sourceShowChart;
                sourceShowChart = this.getShowChart();
                BooleanType copyShowChart = ((BooleanType) strategy.copy(LocatorUtils.property(locator, "showChart", sourceShowChart), sourceShowChart));
                copy.setShowChart(copyShowChart);
            } else {
                copy.showChart = null;
            }
            if (this.isSetShowtable()) {
                BooleanType sourceShowtable;
                sourceShowtable = this.getShowtable();
                BooleanType copyShowtable = ((BooleanType) strategy.copy(LocatorUtils.property(locator, "showtable", sourceShowtable), sourceShowtable));
                copy.setShowtable(copyShowtable);
            } else {
                copy.showtable = null;
            }
            if (this.isSetLimitMaxError()) {
                BigInteger sourceLimitMaxError;
                sourceLimitMaxError = this.getLimitMaxError();
                BigInteger copyLimitMaxError = ((BigInteger) strategy.copy(LocatorUtils.property(locator, "limitMaxError", sourceLimitMaxError), sourceLimitMaxError));
                copy.setLimitMaxError(copyLimitMaxError);
            } else {
                copy.limitMaxError = null;
            }
            if (this.isSetLimitMaxWarning()) {
                BigInteger sourceLimitMaxWarning;
                sourceLimitMaxWarning = this.getLimitMaxWarning();
                BigInteger copyLimitMaxWarning = ((BigInteger) strategy.copy(LocatorUtils.property(locator, "limitMaxWarning", sourceLimitMaxWarning), sourceLimitMaxWarning));
                copy.setLimitMaxWarning(copyLimitMaxWarning);
            } else {
                copy.limitMaxWarning = null;
            }
            if (this.isSetLimitMinWarning()) {
                BigInteger sourceLimitMinWarning;
                sourceLimitMinWarning = this.getLimitMinWarning();
                BigInteger copyLimitMinWarning = ((BigInteger) strategy.copy(LocatorUtils.property(locator, "limitMinWarning", sourceLimitMinWarning), sourceLimitMinWarning));
                copy.setLimitMinWarning(copyLimitMinWarning);
            } else {
                copy.limitMinWarning = null;
            }
            if (this.isSetLimitMinError()) {
                BigInteger sourceLimitMinError;
                sourceLimitMinError = this.getLimitMinError();
                BigInteger copyLimitMinError = ((BigInteger) strategy.copy(LocatorUtils.property(locator, "limitMinError", sourceLimitMinError), sourceLimitMinError));
                copy.setLimitMinError(copyLimitMinError);
            } else {
                copy.limitMinError = null;
            }
            if (this.isSetLimitErrorMessage()) {
                String sourceLimitErrorMessage;
                sourceLimitErrorMessage = this.getLimitErrorMessage();
                String copyLimitErrorMessage = ((String) strategy.copy(LocatorUtils.property(locator, "limitErrorMessage", sourceLimitErrorMessage), sourceLimitErrorMessage));
                copy.setLimitErrorMessage(copyLimitErrorMessage);
            } else {
                copy.limitErrorMessage = null;
            }
            if (this.isSetLimitWarningMessage()) {
                String sourceLimitWarningMessage;
                sourceLimitWarningMessage = this.getLimitWarningMessage();
                String copyLimitWarningMessage = ((String) strategy.copy(LocatorUtils.property(locator, "limitWarningMessage", sourceLimitWarningMessage), sourceLimitWarningMessage));
                copy.setLimitWarningMessage(copyLimitWarningMessage);
            } else {
                copy.limitWarningMessage = null;
            }
            if (this.isSetLimitMode()) {
                BooleanType sourceLimitMode;
                sourceLimitMode = this.getLimitMode();
                BooleanType copyLimitMode = ((BooleanType) strategy.copy(LocatorUtils.property(locator, "limitMode", sourceLimitMode), sourceLimitMode));
                copy.setLimitMode(copyLimitMode);
            } else {
                copy.limitMode = null;
            }
            if (this.isSetValueLookup()) {
                String sourceValueLookup;
                sourceValueLookup = this.getValueLookup();
                String copyValueLookup = ((String) strategy.copy(LocatorUtils.property(locator, "valueLookup", sourceValueLookup), sourceValueLookup));
                copy.setValueLookup(copyValueLookup);
            } else {
                copy.valueLookup = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new ChannelType();
    }
    
    public final void setValue(final Object value) {
        if ((value instanceof Integer)
                || (value instanceof Long)
                || (value instanceof Short)
                || (value instanceof Byte)) {
            this.setFloat(BooleanType.FALSE);
        } else if ((value instanceof Float)
                || (value instanceof Double)) {
            this.setFloat(BooleanType.TRUE);
        }
        this.value = value.toString();
    }

    public ChannelType withValue(final Object value) {
        setValue(value);
        return this;
    }

    public ChannelType() {
    }

    public ChannelType(final String name, final UnitType unit, final Object value) {
        this();
        this.name = name;
        this.unit = unit;
        this.setValue(value);
    }
            
    @SuppressWarnings("unchecked")
    public <F extends ChannelType> F upCast( Class<F> clazz) {
        if (clazz.isInstance(this)) {
            return (F)this;
        } else {
            throw new IllegalArgumentException("Cannot cast instance :"+this.getClass().getName()+" to "+clazz.getName());
        }
    }            

    @SuppressWarnings("unchecked")
    public <F extends ChannelType> F downCast( Class<F> clazz) {
        try {
            final F result = clazz.newInstance();
            this.copyTo(result);
            return result;
        } catch (InstantiationException | IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot create instance :"+this.getClass().getName()+" to "+clazz.getName(),ex);
        }
    }            
    
    public ChannelType downCast() {
            return this.downCast(ChannelType.class);
    }            
            
}
