
package org.adeptnet.prtg.xml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for UnitType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="UnitType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="BytesBandwidth"/>
 *     &lt;enumeration value="BytesMemory"/>
 *     &lt;enumeration value="BytesDisk"/>
 *     &lt;enumeration value="Temperature"/>
 *     &lt;enumeration value="Percent"/>
 *     &lt;enumeration value="TimeResponse"/>
 *     &lt;enumeration value="TimeSeconds"/>
 *     &lt;enumeration value="Custom"/>
 *     &lt;enumeration value="Count"/>
 *     &lt;enumeration value="CPU (*)"/>
 *     &lt;enumeration value="BytesFile"/>
 *     &lt;enumeration value="SpeedDisk"/>
 *     &lt;enumeration value="SpeedNet"/>
 *     &lt;enumeration value="TimeHours"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "UnitType", namespace = "urn:ietf:params:xml:ns:prtg-1.0")
@XmlEnum
public enum UnitType {

    @XmlEnumValue("BytesBandwidth")
    BYTES_BANDWIDTH("BytesBandwidth"),
    @XmlEnumValue("BytesMemory")
    BYTES_MEMORY("BytesMemory"),
    @XmlEnumValue("BytesDisk")
    BYTES_DISK("BytesDisk"),
    @XmlEnumValue("Temperature")
    TEMPERATURE("Temperature"),
    @XmlEnumValue("Percent")
    PERCENT("Percent"),
    @XmlEnumValue("TimeResponse")
    TIME_RESPONSE("TimeResponse"),
    @XmlEnumValue("TimeSeconds")
    TIME_SECONDS("TimeSeconds"),
    @XmlEnumValue("Custom")
    CUSTOM("Custom"),
    @XmlEnumValue("Count")
    COUNT("Count"),
    @XmlEnumValue("CPU (*)")
    CPU("CPU (*)"),
    @XmlEnumValue("BytesFile")
    BYTES_FILE("BytesFile"),
    @XmlEnumValue("SpeedDisk")
    SPEED_DISK("SpeedDisk"),
    @XmlEnumValue("SpeedNet")
    SPEED_NET("SpeedNet"),
    @XmlEnumValue("TimeHours")
    TIME_HOURS("TimeHours");
    private final String value;

    UnitType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static UnitType fromValue(String v) {
        for (UnitType c: UnitType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
