
package org.adeptnet.prtg.xml;

import java.io.Serializable;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for ChannelType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ChannelType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="channel" type="{http://www.w3.org/2001/XMLSchema}token"/&gt;
 *         &lt;element name="value" type="{http://xml.adeptnet.org/prtg/prtg.xsd}ValuePattern" minOccurs="0"/&gt;
 *         &lt;element name="unit" type="{http://xml.adeptnet.org/prtg/prtg.xsd}UnitType" minOccurs="0"/&gt;
 *         &lt;element name="customunit" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/&gt;
 *         &lt;element name="speedsize" type="{http://xml.adeptnet.org/prtg/prtg.xsd}UnitSizeType" minOccurs="0"/&gt;
 *         &lt;element name="volumesize" type="{http://xml.adeptnet.org/prtg/prtg.xsd}UnitSizeType" minOccurs="0"/&gt;
 *         &lt;element name="speedtime" type="{http://xml.adeptnet.org/prtg/prtg.xsd}TimeType" minOccurs="0"/&gt;
 *         &lt;element name="mode" type="{http://xml.adeptnet.org/prtg/prtg.xsd}ModeType" minOccurs="0"/&gt;
 *         &lt;element name="float" type="{http://xml.adeptnet.org/prtg/prtg.xsd}BooleanType" minOccurs="0"/&gt;
 *         &lt;element name="decimalmode" type="{http://xml.adeptnet.org/prtg/prtg.xsd}DecimalModeType" minOccurs="0"/&gt;
 *         &lt;element name="warning" type="{http://xml.adeptnet.org/prtg/prtg.xsd}BooleanType" minOccurs="0"/&gt;
 *         &lt;element name="showchart" type="{http://xml.adeptnet.org/prtg/prtg.xsd}BooleanType" minOccurs="0"/&gt;
 *         &lt;element name="showtable" type="{http://xml.adeptnet.org/prtg/prtg.xsd}BooleanType" minOccurs="0"/&gt;
 *         &lt;element name="limitmaxerror" type="{http://www.w3.org/2001/XMLSchema}integer" minOccurs="0"/&gt;
 *         &lt;element name="limitmaxwarning" type="{http://www.w3.org/2001/XMLSchema}integer" minOccurs="0"/&gt;
 *         &lt;element name="limitminwarning" type="{http://www.w3.org/2001/XMLSchema}integer" minOccurs="0"/&gt;
 *         &lt;element name="limitminerror" type="{http://www.w3.org/2001/XMLSchema}integer" minOccurs="0"/&gt;
 *         &lt;element name="limiterrormsg" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/&gt;
 *         &lt;element name="limitwarningmsg" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/&gt;
 *         &lt;element name="limitmode" type="{http://xml.adeptnet.org/prtg/prtg.xsd}BooleanType" minOccurs="0"/&gt;
 *         &lt;element name="valuelookup" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}base"/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ChannelType", namespace = "http://xml.adeptnet.org/prtg/prtg.xsd", propOrder = {
    "name",
    "value",
    "unit",
    "customUnit",
    "speedSize",
    "volumeSize",
    "speedTime",
    "mode",
    "_float",
    "decimalMode",
    "warning",
    "showChart",
    "showtable",
    "limitMaxError",
    "limitMaxWarning",
    "limitMinWarning",
    "limitMinError",
    "limitErrorMessage",
    "limitWarningMessage",
    "limitMode",
    "valueLookup"
})
public class ChannelType
    implements Serializable
{

    private final static long serialVersionUID = 201401010001L;
    @XmlElement(name = "channel", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String name;
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String value;
    @XmlSchemaType(name = "string")
    protected UnitType unit;
    @XmlElement(name = "customunit")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String customUnit;
    @XmlElement(name = "speedsize")
    @XmlSchemaType(name = "string")
    protected UnitSizeType speedSize;
    @XmlElement(name = "volumesize")
    @XmlSchemaType(name = "string")
    protected UnitSizeType volumeSize;
    @XmlElement(name = "speedtime")
    @XmlSchemaType(name = "string")
    protected TimeType speedTime;
    @XmlSchemaType(name = "string")
    protected ModeType mode;
    @XmlElement(name = "float")
    @XmlSchemaType(name = "string")
    protected BooleanType _float;
    @XmlElement(name = "decimalmode")
    @XmlSchemaType(name = "string")
    protected DecimalModeType decimalMode;
    @XmlSchemaType(name = "string")
    protected BooleanType warning;
    @XmlElement(name = "showchart")
    @XmlSchemaType(name = "string")
    protected BooleanType showChart;
    @XmlSchemaType(name = "string")
    protected BooleanType showtable;
    @XmlElement(name = "limitmaxerror")
    protected BigInteger limitMaxError;
    @XmlElement(name = "limitmaxwarning")
    protected BigInteger limitMaxWarning;
    @XmlElement(name = "limitminwarning")
    protected BigInteger limitMinWarning;
    @XmlElement(name = "limitminerror")
    protected BigInteger limitMinError;
    @XmlElement(name = "limiterrormsg")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String limitErrorMessage;
    @XmlElement(name = "limitwarningmsg")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String limitWarningMessage;
    @XmlElement(name = "limitmode")
    @XmlSchemaType(name = "string")
    protected BooleanType limitMode;
    @XmlElement(name = "valuelookup")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    protected String valueLookup;
    @XmlAttribute(name = "base", namespace = "http://www.w3.org/XML/1998/namespace")
    @XmlSchemaType(name = "anyURI")
    protected String base;

    /**
     * Name of the channel as displayed in user interfaces. This parameter is required and must be unique for the sensor.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * The value as integer or float. Please make sure the &lt;Float&gt; setting matches the kind of value provided. Otherwise PRTG will show 0 values.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * The unit of the value. Default is Custom. Useful for PRTG to be able to convert volumes and times.
     * 
     * @return
     *     possible object is
     *     {@link UnitType }
     *     
     */
    public UnitType getUnit() {
        return unit;
    }

    /**
     * Sets the value of the unit property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnitType }
     *     
     */
    public void setUnit(UnitType value) {
        this.unit = value;
    }

    public boolean isSetUnit() {
        return (this.unit!= null);
    }

    /**
     * If Custom is used as unit this is the text displayed behind the value.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomUnit() {
        return customUnit;
    }

    /**
     * Sets the value of the customUnit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomUnit(String value) {
        this.customUnit = value;
    }

    public boolean isSetCustomUnit() {
        return (this.customUnit!= null);
    }

    /**
     * Size used for the display value. E.g. if you have a value of 50000 and use Kilo as size the display is 50 kilo #. Default is One (value used as returned). For the Bytes and Speed units this is overridden by the setting in the user interface.
     * 
     * @return
     *     possible object is
     *     {@link UnitSizeType }
     *     
     */
    public UnitSizeType getSpeedSize() {
        return speedSize;
    }

    /**
     * Sets the value of the speedSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnitSizeType }
     *     
     */
    public void setSpeedSize(UnitSizeType value) {
        this.speedSize = value;
    }

    public boolean isSetSpeedSize() {
        return (this.speedSize!= null);
    }

    /**
     * Size used for the display value. E.g. if you have a value of 50000 and use Kilo as size the display is 50 kilo #. Default is One (value used as returned). For the Bytes and Speed units this is overridden by the setting in the user interface.
     * 
     * @return
     *     possible object is
     *     {@link UnitSizeType }
     *     
     */
    public UnitSizeType getVolumeSize() {
        return volumeSize;
    }

    /**
     * Sets the value of the volumeSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnitSizeType }
     *     
     */
    public void setVolumeSize(UnitSizeType value) {
        this.volumeSize = value;
    }

    public boolean isSetVolumeSize() {
        return (this.volumeSize!= null);
    }

    /**
     * See above, used when displaying the speed. Default is Second.
     * 
     * @return
     *     possible object is
     *     {@link TimeType }
     *     
     */
    public TimeType getSpeedTime() {
        return speedTime;
    }

    /**
     * Sets the value of the speedTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeType }
     *     
     */
    public void setSpeedTime(TimeType value) {
        this.speedTime = value;
    }

    public boolean isSetSpeedTime() {
        return (this.speedTime!= null);
    }

    /**
     * Selects if the value is a absolut value or counter. Default is Absolute.
     * 
     * @return
     *     possible object is
     *     {@link ModeType }
     *     
     */
    public ModeType getMode() {
        return mode;
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModeType }
     *     
     */
    public void setMode(ModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

    /**
     * Define if the value is a float. Default is 0 (no). If set to 1 (yes), use a dot as decimal seperator in values. Note: Define decimal places with the &lt;DecimalMode&gt; element.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getFloat() {
        return _float;
    }

    /**
     * Sets the value of the float property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setFloat(BooleanType value) {
        this._float = value;
    }

    public boolean isSetFloat() {
        return (this._float!= null);
    }

    /**
     * Init value for the Decimal Places option. If 0 is used in the &lt;Float&gt; element (i.e. use integer), the default is Auto; otherwise (i.e. for float) default is All. Note: In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link DecimalModeType }
     *     
     */
    public DecimalModeType getDecimalMode() {
        return decimalMode;
    }

    /**
     * Sets the value of the decimalMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DecimalModeType }
     *     
     */
    public void setDecimalMode(DecimalModeType value) {
        this.decimalMode = value;
    }

    public boolean isSetDecimalMode() {
        return (this.decimalMode!= null);
    }

    /**
     * If enabled for at least one channel, the entire sensor is set to warning status. Default is 0 (no).
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getWarning() {
        return warning;
    }

    /**
     * Sets the value of the warning property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setWarning(BooleanType value) {
        this.warning = value;
    }

    public boolean isSetWarning() {
        return (this.warning!= null);
    }

    /**
     * Init value for the Show in Chart option. Default is 1 (yes). Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getShowChart() {
        return showChart;
    }

    /**
     * Sets the value of the showChart property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setShowChart(BooleanType value) {
        this.showChart = value;
    }

    public boolean isSetShowChart() {
        return (this.showChart!= null);
    }

    /**
     * Init value for the Show in Table option. Default is 1 (yes). Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getShowtable() {
        return showtable;
    }

    /**
     * Sets the value of the showtable property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setShowtable(BooleanType value) {
        this.showtable = value;
    }

    public boolean isSetShowtable() {
        return (this.showtable!= null);
    }

    /**
     * Define an upper error limit for the channel. If enabled, the sensor will be set to a "Down" status if this value is overrun and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. While a sensor shows a "Down" status triggered by a limit, it will still receive data in its channels. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMaxError() {
        return limitMaxError;
    }

    /**
     * Sets the value of the limitMaxError property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMaxError(BigInteger value) {
        this.limitMaxError = value;
    }

    public boolean isSetLimitMaxError() {
        return (this.limitMaxError!= null);
    }

    /**
     * Define an upper warning limit for the channel. If enabled, the sensor will be set to a "Warning" status if this value is overrun and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMaxWarning() {
        return limitMaxWarning;
    }

    /**
     * Sets the value of the limitMaxWarning property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMaxWarning(BigInteger value) {
        this.limitMaxWarning = value;
    }

    public boolean isSetLimitMaxWarning() {
        return (this.limitMaxWarning!= null);
    }

    /**
     * Define a lower warning limit for the channel. If enabled, the sensor will be set to a "Warning" status if this value is undercut and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMinWarning() {
        return limitMinWarning;
    }

    /**
     * Sets the value of the limitMinWarning property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMinWarning(BigInteger value) {
        this.limitMinWarning = value;
    }

    public boolean isSetLimitMinWarning() {
        return (this.limitMinWarning!= null);
    }

    /**
     * Define a lower error limit for the channel. If enabled, the sensor will be set to a "Down" status if this value is undercut and the LimitMode is activated. Note: Please provide the limit value in the unit of the base data type, just as used in the &lt;Value&gt; element of this section. While a sensor shows a "Down" status triggered by a limit, it will still receive data in its channels. The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLimitMinError() {
        return limitMinError;
    }

    /**
     * Sets the value of the limitMinError property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLimitMinError(BigInteger value) {
        this.limitMinError = value;
    }

    public boolean isSetLimitMinError() {
        return (this.limitMinError!= null);
    }

    /**
     * Define an additional message. It will be added to the sensor's message when entering a "Down" status that is triggered by a limit. Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLimitErrorMessage() {
        return limitErrorMessage;
    }

    /**
     * Sets the value of the limitErrorMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLimitErrorMessage(String value) {
        this.limitErrorMessage = value;
    }

    public boolean isSetLimitErrorMessage() {
        return (this.limitErrorMessage!= null);
    }

    /**
     * Define an additional message. It will be added to the sensor's message when entering a "Warning" status that is triggered by a limit. Note: The values defined with this element will be considered only on the first sensor scan, when the channel is newly created; they are ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLimitWarningMessage() {
        return limitWarningMessage;
    }

    /**
     * Sets the value of the limitWarningMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLimitWarningMessage(String value) {
        this.limitWarningMessage = value;
    }

    public boolean isSetLimitWarningMessage() {
        return (this.limitWarningMessage!= null);
    }

    /**
     * Define if the limit settings defined above will be active. Default is 0 (no; limits inactive). If 0 is used the limits will be written to the sensor channel settings as predefined values, but limits will be disabled. Note: This setting will be considered only on the first sensor scan, when the channel is newly created; it is ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link BooleanType }
     *     
     */
    public BooleanType getLimitMode() {
        return limitMode;
    }

    /**
     * Sets the value of the limitMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link BooleanType }
     *     
     */
    public void setLimitMode(BooleanType value) {
        this.limitMode = value;
    }

    public boolean isSetLimitMode() {
        return (this.limitMode!= null);
    }

    /**
     * Define if you want to use a lookup file (e.g. to view integer values as status texts). Please enter the ID of the lookup file you want to use, or omit this element to not use lookups. Note: This setting will be considered only on the first sensor scan, when the channel is newly created; it is ignored on all further sensor scans (and may be omitted). In the sensor's Channels tab, you can change this initial setting later.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValueLookup() {
        return valueLookup;
    }

    /**
     * Sets the value of the valueLookup property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValueLookup(String value) {
        this.valueLookup = value;
    }

    public boolean isSetValueLookup() {
        return (this.valueLookup!= null);
    }

    /**
     * Gets the value of the base property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBase() {
        return base;
    }

    /**
     * Sets the value of the base property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBase(String value) {
        this.base = value;
    }

    public boolean isSetBase() {
        return (this.base!= null);
    }
    
    public final void setValue(final Object value) {
        if ((value instanceof Integer)
                || (value instanceof Long)
                || (value instanceof Short)
                || (value instanceof Byte)) {
            this.setFloat(BooleanType.FALSE);
        } else if ((value instanceof Float)
                || (value instanceof Double)) {
            this.setFloat(BooleanType.TRUE);
        }
        this.value = value.toString();
    }

    public ChannelType withValue(final Object value) {
        setValue(value);
        return this;
    }

    public ChannelType() {
    }

    public ChannelType(final String name, final UnitType unit, final Object value) {
        this();
        this.name = name;
        this.unit = unit;
        this.setValue(value);
    }
            
    @SuppressWarnings("unchecked")
    public <F extends ChannelType> F upCast( Class<F> clazz) {
        if (clazz.isInstance(this)) {
            return (F)this;
        } else {
            throw new IllegalArgumentException("Cannot cast instance :"+this.getClass().getName()+" to "+clazz.getName());
        }
    }            
            
}
