/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.adeptnet.prtg.xml.ObjectFactory;
import org.adeptnet.prtg.xml.Prtg;
import org.apache.xerces.dom.DOMInputImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;

public class JaxbManager
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger(JaxbManager.class.getName());
    private static final String META_INF = "META-INF";
    protected static final String META_INF_PRTG = "META-INF/prtg/";
    private String basePath;

    public List<String> getSchemaNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("META-INF/prtg/xml.xsd");
        result.add("META-INF/prtg/prtg.xsd");
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
    }

    public Map<String, Source> getSchemaSourcesFromResource(List<String> schemaNames) throws SAXException {
        HashMap<String, Source> sources = new HashMap<String, Source>();
        for (String schemaResource : schemaNames) {
            InputStream is = this.getResourceAsStream(schemaResource);
            if (is == null) {
                throw new SAXException(String.format("resource null: %s", schemaResource));
            }
            sources.put(schemaResource, new StreamSource(is));
        }
        return sources;
    }

    public Map<String, Source> getSchemaSources() throws SAXException {
        return this.getSchemaSourcesFromResource(this.getSchemaNames());
    }

    public List<Class<?>> getKnownClasses() {
        ArrayList result = new ArrayList();
        result.add(ObjectFactory.class);
        return result;
    }

    public JAXBContext getJAXBContext() throws JAXBException {
        List<Class<?>> _knownClasses = this.getKnownClasses();
        return JAXBContext.newInstance((Class[])_knownClasses.toArray(new Class[_knownClasses.size()]));
    }

    private InputStream getSchemaSourceFromSystemId(String systemId) {
        Map<String, Source> list;
        try {
            list = this.getSchemaSources();
        }
        catch (SAXException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        if (list.containsKey(systemId)) {
            Source source = list.get(systemId);
            if (source instanceof StreamSource) {
                return ((StreamSource)source).getInputStream();
            }
            return null;
        }
        return null;
    }

    private LSResourceResolver getResourceResolver() {
        return new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                InputStream is;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("%s LSResourceResolver - resolveResource type [%s] namespaceURI [%s] publicId [%s] systemId [%s] baseURI [%s]", JaxbManager.class, type, namespaceURI, publicId, systemId, baseURI));
                }
                if (systemId == null) {
                    if ("http://www.w3.org/2001/XMLSchema".equals(type) && "http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                        systemId = "META-INF/prtg/xml.xsd";
                    } else {
                        try {
                            URI uri = new URI(namespaceURI);
                            systemId = JaxbManager.META_INF + uri.getPath();
                        }
                        catch (URISyntaxException ex) {
                            LOG.log(Level.SEVERE, String.format("Invalid URI: %s", ex.getMessage()), ex);
                            return null;
                        }
                    }
                }
                if ((is = JaxbManager.this.getSchemaSourceFromSystemId(systemId)) != null) {
                    DOMInputImpl ls = new DOMInputImpl();
                    ls.setByteStream(is);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("returning: %s", systemId));
                    }
                    return ls;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("returning: NULL");
                }
                return null;
            }
        };
    }

    private Source[] getSchemaSourcesArray() throws SAXException {
        Collection<Source> sources = this.getSchemaSources().values();
        return sources.toArray(new Source[sources.size()]);
    }

    private Schema getSchema() throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setErrorHandler(this);
        sf.setResourceResolver(this.getResourceResolver());
        return sf.newSchema(this.getSchemaSourcesArray());
    }

    public String getBasePath() {
        return this.basePath;
    }

    private EntityResolver2 getEntityResolver() {
        return new EntityResolver2(){

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("%s getExternalSubset: name [%s] baseURI [%s]", JaxbManager.class, name, baseURI));
                }
                return null;
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                String path;
                File _file1;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("%s EntityResolver2 - resolveEntity name [%s] publicId [%s] baseURI [%s] systemId [%s]", JaxbManager.class, name, publicId, baseURI, systemId));
                }
                if ((_file1 = new File(systemId)).exists()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("returning1: %s", _file1.getAbsoluteFile().getName()));
                    }
                    return new InputSource(new FileReader(_file1));
                }
                try {
                    URI uri = new URI(systemId);
                    path = JaxbManager.META_INF + uri.getPath();
                }
                catch (URISyntaxException ex) {
                    LOG.log(Level.SEVERE, String.format("Invalid URI: %s", ex.getMessage()), ex);
                    return null;
                }
                InputStream is = JaxbManager.this.getSchemaSourceFromSystemId(path);
                if (is != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("returning2: %s", path));
                    }
                    return new InputSource(is);
                }
                File _file2 = new File(JaxbManager.this.getBasePath(), systemId);
                if (_file2.exists()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("returning3: %s", _file2.getAbsoluteFile().getName()));
                    }
                    return new InputSource(new FileReader(_file2));
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("returning: NULL");
                }
                return null;
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("%s EntityResolver2 - resolveEntity publicId [%s] systemId [%s]", JaxbManager.class, publicId, systemId));
                }
                return null;
            }
        };
    }

    protected DocumentBuilder getDocumentBuilder(Schema schema) throws SAXException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setSchema(schema);
        builderFactory.setValidating(true);
        builderFactory.setCoalescing(true);
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        builderFactory.setNamespaceAware(true);
        builderFactory.setXIncludeAware(true);
        try {
            builderFactory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            builderFactory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            builderFactory.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
            builderFactory.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            builderFactory.setFeature("http://apache.org/xml/features/warn-on-duplicate-entitydef", true);
            builderFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            builderFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(this.getEntityResolver());
            builder.setErrorHandler(this);
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(String.format("getDocumentBuilder() - %s", e.getMessage()), e);
        }
    }

    public <T> T fromXML(File file, Class<T> clazz) throws JAXBException {
        try {
            this.basePath = file.getAbsoluteFile().getParent() + File.separator;
            Unmarshaller _unm = this.getJAXBContext().createUnmarshaller();
            Schema schema = this.getSchema();
            _unm.setSchema(schema);
            DocumentBuilder builder = this.getDocumentBuilder(schema);
            Document doc = builder.parse(new FileInputStream(file));
            Object result = _unm.unmarshal((Node)doc.getDocumentElement());
            if (!clazz.isInstance(result)) {
                throw new JAXBException(String.format("fromXML(): Not assignable [%s] - [%s]", clazz.getName(), result.getClass().getName()));
            }
            return (T)result;
        }
        catch (IOException | SAXException ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    public Prtg toPrtg(File file) throws JAXBException {
        return this.fromXML(file, Prtg.class);
    }

    public String toXML(Object object) throws JAXBException {
        Marshaller marshal = this.getJAXBContext().createMarshaller();
        marshal.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshal.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter sw = new StringWriter();
        marshal.marshal(object, (Writer)sw);
        return sw.toString();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        LOG.log(Level.WARNING, "warning", exception);
        throw exception;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        LOG.log(Level.SEVERE, "error", exception);
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        LOG.log(Level.SEVERE, "fatalError", exception);
        throw exception;
    }
}

