/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.maven.wagon.providers.http;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.adeptnet.maven.wagon.providers.http.Nameserver;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.ietf.jgss.GSSException;

@Immutable
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private static final Logger LOG = Logger.getLogger(SPNegoSchemeFactory.class.getName());
    private final boolean stripPort;

    public SPNegoSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
    }

    public SPNegoSchemeFactory() {
        this(false);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public AuthScheme newInstance(HttpParams params) {
        return new InternalSPNegoScheme(this.stripPort);
    }

    public AuthScheme create(HttpContext context) {
        return new InternalSPNegoScheme(this.stripPort);
    }

    private static class InternalSPNegoScheme
    extends SPNegoScheme {
        private static final Map<String, InternalCacheEntry> cache = new HashMap<String, InternalCacheEntry>();

        public InternalSPNegoScheme(boolean stripPort) {
            super(stripPort);
        }

        public InternalSPNegoScheme() {
            this(false);
        }

        private String normalize(String data) {
            if (data.isEmpty()) {
                return data;
            }
            if (data.endsWith(".")) {
                return this.normalize(data.substring(0, data.length() - 1));
            }
            return data;
        }

        private String recurseResolveToA(Nameserver ns, Set<String> checked, String host) throws NamingException {
            if (checked.contains(host)) {
                throw new NamingException(String.format("Recursive Name Lookup: %s", checked));
            }
            String[] clookup = ns.lookup(host, "cname");
            if (clookup.length != 0) {
                checked.add(host);
                return this.recurseResolveToA(ns, checked, this.normalize(clookup[0]));
            }
            return host;
        }

        protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
            InternalCacheEntry entry;
            if (cache.containsKey(authServer) && (entry = cache.get(authServer)).hasExpired()) {
                cache.remove(authServer);
            }
            if (!cache.containsKey(authServer)) {
                String server;
                try {
                    server = this.recurseResolveToA(new Nameserver(), new HashSet<String>(), authServer);
                }
                catch (NamingException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    server = authServer;
                }
                InternalCacheEntry entry2 = new InternalCacheEntry(authServer, System.currentTimeMillis(), super.generateToken(input, server));
                cache.put(authServer, entry2);
            }
            return cache.get(authServer).getToken();
        }
    }

    private static class InternalCacheEntry {
        private static final long CACHE = 60000L;
        private final String server;
        private final long age;
        private final byte[] token;

        public InternalCacheEntry(String server, long age, byte[] token) {
            this.server = server;
            this.age = age;
            this.token = token;
        }

        public String getServer() {
            return this.server;
        }

        public long getAge() {
            return this.age;
        }

        public byte[] getToken() {
            return this.token;
        }

        public boolean hasExpired() {
            return this.age + 60000L < System.currentTimeMillis();
        }
    }
}

