/*
 * Copyright (c) 2007, 2017 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.jemmy.control;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jemmy.env.Environment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * This loads information about the supported wrappers from an xml file which is
 * generated by JemmySupport module.
 * @author shura
 */
public class JemmySupportWrapper extends LazyWrapper {

    public static final String CONTROL = "control";
    public static final String WRAP = "wrap";

    public JemmySupportWrapper(ClassLoader loader, InputStream in, Environment env) throws ParserConfigurationException, SAXException, IOException {
        super(loader, env);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        readAll(doc.getDocumentElement());
    }

    public JemmySupportWrapper(ClassLoader loader, String resource, Environment env) throws ParserConfigurationException, SAXException, IOException {
        this(loader, loader.getResourceAsStream(resource), env);
    }

    private void readAll(Element element) {
        NodeList cntrls = element.getElementsByTagName(CONTROL);
        for(int i = 0; i < cntrls.getLength(); i++) {
            readControl((Element)cntrls.item(i));
        }
    }

    private void readControl(Element control) {
        add(control.getAttribute(CONTROL), control.getAttribute(WRAP));
    }

}
