/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jemmy.JemmyException;

public class Version {
    public static final Version VERSION = new Version();
    private int major;
    private int minor;
    private int mini;
    private String build;

    public Version() {
        this(Version.class.getPackage().getName());
    }

    public Version(String pkg) {
        try {
            Properties props = new Properties();
            String fileName = pkg.replace(".", "/") + "/jemmy.properties";
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (in == null) {
                throw new JemmyException("Can not get version - no " + fileName + " file");
            }
            props.load(in);
            this.major = Integer.parseInt(props.getProperty("version.major"));
            this.minor = Integer.parseInt(props.getProperty("version.minor"));
            this.mini = Integer.parseInt(props.getProperty("version.mini"));
            this.build = props.getProperty("build");
        }
        catch (IOException ex) {
            throw new JemmyException("Can not get version.", ex);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMini() {
        return this.mini;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getVersion() {
        return this.major + "." + this.minor + "." + this.mini;
    }

    public String getBuild() {
        return this.build;
    }

    public boolean newer(String old) {
        StringTokenizer tn = new StringTokenizer(old, ".");
        return this.major >= Integer.parseInt(tn.nextToken()) && this.minor >= Integer.parseInt(tn.nextToken()) && this.mini >= Integer.parseInt(tn.nextToken());
    }

    public static void main(String[] args) {
        System.out.println("JemmyCore version: " + VERSION.getVersion() + "." + Version.VERSION.build);
    }
}

