/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import org.jemmy.Point;
import org.jemmy.Vector;
import org.jemmy.action.Action;
import org.jemmy.control.Wrap;
import org.jemmy.env.Timeout;
import org.jemmy.interfaces.Caret;
import org.jemmy.interfaces.Drag;
import org.jemmy.interfaces.Scroll;

public abstract class KnobDragScrollerImpl
implements Caret {
    public static final int MAX_SCROLL_ATTEMPTS = 5;
    Wrap<?> wrap;
    Scroll scroll;
    float dragDelta = 1.0f;
    boolean reverse;

    public KnobDragScrollerImpl(Wrap<?> wrap, Scroll scroll) {
        this.wrap = wrap;
        this.scroll = scroll;
    }

    public KnobDragScrollerImpl(Wrap<?> wrap, Scroll scroll, boolean reverse) {
        this(wrap, scroll);
        this.reverse = reverse;
    }

    public Wrap<?> getWrap() {
        return this.wrap;
    }

    public abstract Vector getScrollVector();

    public void setDragDelta(float dragDelta) {
        this.dragDelta = dragDelta;
    }

    private void toKnob(Wrap<?> knob, Point inWrap) {
        inWrap.translate(this.wrap.getScreenBounds().x, this.wrap.getScreenBounds().y);
        inWrap.translate(-knob.getScreenBounds().x, -knob.getScreenBounds().y);
    }

    private void toWrap(Wrap<?> knob, Point inWrap) {
        inWrap.translate(knob.getScreenBounds().x, knob.getScreenBounds().y);
        inWrap.translate(-this.wrap.getScreenBounds().x, -this.wrap.getScreenBounds().y);
    }

    @Override
    public void to(double value) {
        this.scroll.to(value);
    }

    @Override
    public void to(final Caret.Direction condition) {
        this.wrap.getEnvironment().getExecutor().execute(this.wrap.getEnvironment(), false, new Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Object ... parameters) {
                int toOrig;
                int dragAttempt = 0;
                Timeout moveTimeout = KnobDragScrollerImpl.this.wrap.getEnvironment().getTimeout(Drag.IN_DRAG_TIMEOUT).clone();
                while ((toOrig = condition.to()) != 0) {
                    Vector axis = KnobDragScrollerImpl.this.getScrollVector().multiply(toOrig).setLenght(KnobDragScrollerImpl.this.dragDelta);
                    if (KnobDragScrollerImpl.this.reverse) {
                        axis.multiply(-1.0);
                    }
                    Vector shift = axis.clone();
                    Wrap<?> knob = KnobDragScrollerImpl.this.getKnob();
                    Point orig = new Point(knob.getScreenBounds().getX() + knob.getScreenBounds().getWidth() / 2.0, knob.getScreenBounds().getY() + knob.getScreenBounds().getHeight() / 2.0);
                    knob.mouse().move(knob.toLocal(orig.getLocation()));
                    knob.mouse().press();
                    KnobDragScrollerImpl.this.wrap.getEnvironment().getTimeout(Drag.BEFORE_DRAG_TIMEOUT).sleep();
                    try {
                        while (condition.to() == toOrig) {
                            KnobDragScrollerImpl.this.wrap.getEnvironment().getTimeout(Drag.IN_DRAG_TIMEOUT).sleep();
                            knob.mouse().move(knob.toLocal(orig.getLocation().translate(shift)));
                            if (KnobDragScrollerImpl.this.scroll.position() == KnobDragScrollerImpl.this.scroll.minimum()) break;
                            if (KnobDragScrollerImpl.this.scroll.position() == KnobDragScrollerImpl.this.scroll.maximum()) {
                                break;
                            }
                            shift.add(axis);
                        }
                    }
                    finally {
                        KnobDragScrollerImpl.this.wrap.getEnvironment().getTimeout(Drag.BEFORE_DROP_TIMEOUT).sleep();
                        knob.mouse().release();
                    }
                    if (++dragAttempt >= 5) {
                        return;
                    }
                    moveTimeout.setValue((long)((double)moveTimeout.getValue() * 1.5));
                }
            }
        }, new Object[0]);
    }

    protected abstract Wrap<?> getKnob();
}

