/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.timing;

import org.jemmy.JemmyException;
import org.jemmy.TimeoutExpiredException;
import org.jemmy.env.Timeout;
import org.jemmy.timing.State;

public class Waiter {
    public static final Timeout DEFAULT_DELTA = new Timeout("default.wait.delta", 100L);
    private long waitTime;
    private long delta;

    public Waiter(Timeout waitTime, Timeout delta) {
        this.waitTime = waitTime.getValue();
        this.delta = delta.getValue();
    }

    public Waiter(Timeout waitTime) {
        this.waitTime = waitTime.getValue();
        this.delta = DEFAULT_DELTA.getValue();
    }

    public <T> T waitState(State<T> state) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + this.waitTime) {
            T res = state.reached();
            if (res != null) {
                return res;
            }
            try {
                Thread.sleep(this.delta);
            }
            catch (InterruptedException ex) {
                throw new JemmyException("Wait interrupted for: ", state);
            }
        }
        return null;
    }

    public <T> T waitValue(final T value, final State<T> state) {
        State st = new State<T>(){

            @Override
            public T reached() {
                Object res = state.reached();
                if (res != null && res.equals(value)) {
                    return res;
                }
                return null;
            }
        };
        return this.waitState(st);
    }

    public <T> T ensureState(State<T> state) {
        T res = this.waitState(state);
        if (res == null) {
            throw new TimeoutExpiredException("State '" + state + "' has not been reached in " + this.waitTime + " milliseconds");
        }
        return res;
    }

    public <T> T ensureValue(T value, State<T> state) {
        T res = this.waitValue(value, state);
        if (res == null) {
            throw new TimeoutExpiredException("State '" + state + "' has not been reached in " + this.waitTime + " milliseconds");
        }
        return res;
    }
}

