/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.ProxyWrapper;
import org.adridadou.ethereum.blockchain.BlockchainProxy;
import org.adridadou.ethereum.converters.input.EthAccountHandler;
import org.adridadou.ethereum.converters.input.EthAddressHandler;
import org.adridadou.ethereum.converters.input.EthDataHandler;
import org.adridadou.ethereum.converters.input.EthValueHandler;
import org.adridadou.ethereum.converters.input.InputTypeHandler;
import org.adridadou.ethereum.converters.output.AddressHandler;
import org.adridadou.ethereum.converters.output.BooleanHandler;
import org.adridadou.ethereum.converters.output.EnumHandler;
import org.adridadou.ethereum.converters.output.IntegerHandler;
import org.adridadou.ethereum.converters.output.LongHandler;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.converters.output.StringHandler;
import org.adridadou.ethereum.converters.output.VoidHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.SmartContractInfo;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.exception.ContractNotFoundException;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;

public class EthereumContractInvocationHandler
implements InvocationHandler {
    private final Map<EthAddress, Map<EthAccount, SmartContract>> contracts = new HashMap<EthAddress, Map<EthAccount, SmartContract>>();
    private final BlockchainProxy blockchainProxy;
    private final List<OutputTypeHandler<?>> outputHandlers;
    private final List<InputTypeHandler<? extends Object>> inputHandlers;
    private final Map<ProxyWrapper, SmartContractInfo> info = new HashMap<ProxyWrapper, SmartContractInfo>();

    EthereumContractInvocationHandler(BlockchainProxy blockchainProxy) {
        this.blockchainProxy = blockchainProxy;
        this.outputHandlers = Lists.newArrayList((Object[])new OutputTypeHandler[]{new IntegerHandler(), new LongHandler(), new StringHandler(), new BooleanHandler(), new AddressHandler(), new VoidHandler(), new EnumHandler()});
        this.inputHandlers = Lists.newArrayList((Object[])new InputTypeHandler[]{new EthAddressHandler(), new EthAccountHandler(), new EthDataHandler(), new EthValueHandler()});
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        SmartContractInfo contractInfo = this.info.get(new ProxyWrapper(proxy));
        SmartContract contract = this.contracts.get(contractInfo.getAddress()).get(contractInfo.getSender());
        Object[] arguments = Optional.ofNullable(args).map(this::prepareArguments).orElse(new Object[0]);
        if (method.getReturnType().equals(Void.TYPE)) {
            contract.callFunction(methodName, arguments);
            return Void.TYPE;
        }
        if (method.getReturnType().isAssignableFrom(CompletableFuture.class)) {
            return contract.callFunction(methodName, arguments).thenApply(result -> this.convertResult((Object[])result, method));
        }
        return this.convertResult(contract.callConstFunction(methodName, arguments), method);
    }

    private Object[] prepareArguments(Object[] args) {
        return Arrays.stream(args).map(arg -> this.inputHandlers.stream().filter(handler -> handler.isOfType(arg.getClass())).findFirst().map(handler -> handler.convert(arg)).orElse(arg)).toArray();
    }

    private Object convertResult(Object[] result, Method method) {
        if (result.length == 1) {
            return this.convertResult(result[0], method.getReturnType(), method.getGenericReturnType());
        }
        return this.convertSpecificType(result, method.getReturnType());
    }

    private Object convertSpecificType(Object[] result, Class<?> returnType) {
        Object[] params = new Object[result.length];
        Constructor constr = this.lookForNonEmptyConstructor(returnType, result);
        for (int i = 0; i < result.length; ++i) {
            params[i] = this.convertResult(result[i], constr.getParameterTypes()[i], constr.getGenericParameterTypes()[i]);
        }
        try {
            return constr.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EthereumApiException("error while converting to a specific type", e);
        }
    }

    private Class<?> getCollectionType(Class<?> returnType, Type genericType) {
        if (returnType.isArray()) {
            return returnType.getComponentType();
        }
        if (List.class.equals(returnType)) {
            return this.getGenericType(genericType);
        }
        return null;
    }

    private Class<?> getGenericType(Type genericType) {
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }

    private <T> T[] convertArray(Class<T> cls, Object[] arr) {
        for (OutputTypeHandler<T> outputTypeHandler : this.outputHandlers) {
            if (!outputTypeHandler.isOfType(cls)) continue;
            Object[] result = (Object[])Array.newInstance(cls, arr.length);
            for (int i = 0; i < arr.length; ++i) {
                result[i] = outputTypeHandler.convert(arr[i], cls);
            }
            return result;
        }
        throw new IllegalArgumentException("no handler founds to convert " + cls.getSimpleName());
    }

    private <T> List<T> convertList(Class<T> cls, Object[] arr) {
        for (OutputTypeHandler<T> outputTypeHandler : this.outputHandlers) {
            if (!outputTypeHandler.isOfType(cls)) continue;
            ArrayList result = new ArrayList();
            for (Object obj : arr) {
                result.add(outputTypeHandler.convert(obj, cls));
            }
            return result;
        }
        throw new IllegalArgumentException("no handler founds to convert " + cls.getSimpleName());
    }

    private Object convertResult(Object result, Class<?> returnType, Type genericType) {
        Class<?> arrType = this.getCollectionType(returnType, genericType);
        Class<?> actualReturnType = returnType;
        if (arrType != null) {
            if (returnType.isArray()) {
                return this.convertArray(arrType, (Object[])result);
            }
            return this.convertList(arrType, (Object[])result);
        }
        if (returnType.equals(CompletableFuture.class)) {
            actualReturnType = this.getGenericType(genericType);
        }
        for (OutputTypeHandler<?> handler : this.outputHandlers) {
            if (!handler.isOfType(actualReturnType)) continue;
            return handler.convert(result, actualReturnType);
        }
        return this.convertSpecificType(new Object[]{result}, returnType);
    }

    private Constructor lookForNonEmptyConstructor(Class<?> returnType, Object[] result) {
        for (Constructor<?> constructor : returnType.getConstructors()) {
            if (constructor.getParameterCount() <= 0) continue;
            if (constructor.getParameterCount() != result.length) {
                throw new IllegalArgumentException("the number of arguments don't match for type " + returnType.getSimpleName() + ". Constructor has " + constructor.getParameterCount() + " and result has " + result.length);
            }
            return constructor;
        }
        throw new IllegalArgumentException("no constructor with arguments found! for type " + returnType.getSimpleName());
    }

    <T> void register(T proxy, Class<T> contractInterface, SoliditySource code, String contractName, EthAddress address, EthAccount sender) throws IOException {
        Map contractsFound = this.compile((String)code.getSource()).contracts;
        CompilationResult.ContractMetadata found = null;
        for (Map.Entry entry : contractsFound.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(contractName)) continue;
            if (found != null) {
                throw new EthereumApiException("more than one Contract found for " + contractInterface.getSimpleName());
            }
            found = (CompilationResult.ContractMetadata)entry.getValue();
        }
        if (found == null) {
            throw new ContractNotFoundException("no contract found for " + contractInterface.getSimpleName());
        }
        SmartContract smartContract = this.blockchainProxy.map(code, contractName, address, sender);
        this.verifyContract(smartContract, contractInterface);
        this.info.put(new ProxyWrapper(proxy), new SmartContractInfo(address, sender));
        Map proxies = this.contracts.getOrDefault(address, new HashMap());
        proxies.put(sender, smartContract);
        this.contracts.put(address, proxies);
    }

    <T> void register(T proxy, Class<T> contractInterface, ContractAbi abi, EthAddress address, EthAccount sender) throws IOException {
        SmartContract smartContract = this.blockchainProxy.mapFromAbi(abi, address, sender);
        this.verifyContract(smartContract, contractInterface);
        this.info.put(new ProxyWrapper(proxy), new SmartContractInfo(address, sender));
        Map proxies = this.contracts.getOrDefault(address, new HashMap());
        proxies.put(sender, smartContract);
        this.contracts.put(address, proxies);
    }

    private void verifyContract(SmartContract smartContract, Class<?> contractInterface) {
        Set solidityFuncNames;
        HashSet interfaceMethods = Sets.newHashSet((Object[])contractInterface.getMethods());
        Set solidityMethods = smartContract.getFunctions().stream().filter(f -> f != null).collect(Collectors.toSet());
        Set interfaceMethodNames = interfaceMethods.stream().map(Method::getName).collect(Collectors.toSet());
        Sets.SetView superfluous = Sets.difference(interfaceMethodNames, solidityFuncNames = solidityMethods.stream().map(d -> d.name).collect(Collectors.toSet()));
        if (!superfluous.isEmpty()) {
            throw new EthereumApiException("superflous function definition in interface " + contractInterface.getName() + ":" + superfluous.toString());
        }
        Map methods = interfaceMethods.stream().collect(Collectors.toMap(Method::getName, Function.identity()));
        for (CallTransaction.Function func : solidityMethods) {
            if (methods.get(func.name) == null || func.inputs.length == ((Method)methods.get(func.name)).getParameterCount()) continue;
            throw new EthereumApiException("parameter count mismatch for " + func.name + " on contract " + contractInterface.getName());
        }
    }

    private CompilationResult compile(String contract) throws IOException {
        SolidityCompiler.Result res = SolidityCompiler.compile((byte[])contract.getBytes(EthereumFacade.CHARSET), (boolean)true, (SolidityCompiler.Options[])new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE});
        return CompilationResult.parse((String)res.output);
    }
}

