/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.exception.EthereumApiException;

public interface BlockchainProxy {
    public SmartContract map(SoliditySource var1, String var2, EthAddress var3, EthAccount var4);

    public SmartContract mapFromAbi(ContractAbi var1, EthAddress var2, EthAccount var3);

    public CompletableFuture<EthAddress> publish(SoliditySource var1, String var2, EthAccount var3, Object ... var4);

    public CompletableFuture<EthExecutionResult> sendTx(EthValue var1, EthData var2, EthAccount var3, EthAddress var4);

    public CompletableFuture<EthAddress> sendTx(EthValue var1, EthData var2, EthAccount var3);

    public EthereumEventHandler events();

    public boolean addressExists(EthAddress var1);

    public EthValue getBalance(EthAddress var1);

    default public void hasEnoughFund(EthAddress address, EthValue requiredFund) {
        if (this.getBalance(address).compareTo(requiredFund) < 0) {
            throw new EthereumApiException("not enough fund for " + address.withLeading0x());
        }
    }
}

