/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainProxy;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractRpc;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Transaction;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.RawTransaction;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class BlockchainProxyRpc
implements BlockchainProxy {
    private static final int SLEEP_DURATION = 5000;
    private static final int ATTEMPTS = 120;
    private static final Logger log = LoggerFactory.getLogger(BlockchainProxyRpc.class);
    private final Map<EthAccount, BigInteger> pendingTransactions = new CopyOnWriteMap();
    private final Web3j web3j;

    public BlockchainProxyRpc(Web3j web3j) {
        this.web3j = web3j;
    }

    @Override
    public SmartContract map(SoliditySource src, String contractName, EthAddress address, EthAccount sender) {
        try {
            CompilationResult.ContractMetadata metadata = this.compile(src, contractName);
            return this.mapFromAbi(new ContractAbi(metadata.abi), address, sender);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while mapping a smart contract", e);
        }
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, EthAccount sender) {
        return new SmartContractRpc(abi.getAbi(), this.web3j, sender, address, this);
    }

    @Override
    public CompletableFuture<EthAddress> publish(SoliditySource code, String contractName, EthAccount sender, Object ... constructorArgs) {
        try {
            return this.createContract(code, contractName, sender, constructorArgs).thenApply(SmartContractRpc::getAddress);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while publishing " + contractName + ":", e);
        }
    }

    private CompletableFuture<SmartContractRpc> createContract(SoliditySource soliditySrc, String contractName, EthAccount sender, Object ... constructorArgs) throws IOException {
        CompilationResult.ContractMetadata metadata = this.compile(soliditySrc, contractName);
        CallTransaction.Contract contract = new CallTransaction.Contract(metadata.abi);
        CallTransaction.Function constructor = contract.getConstructor();
        if (constructor == null && constructorArgs.length > 0) {
            throw new EthereumApiException("No constructor with params found");
        }
        byte[] argsEncoded = constructor == null ? new byte[]{} : constructor.encodeArguments(constructorArgs);
        return this.sendTx(EthValue.wei(1), EthData.of(ByteUtil.merge((byte[][])new byte[][]{Hex.decode((String)metadata.bin), argsEncoded})), sender).thenApply(address -> new SmartContractRpc(metadata.abi, this.web3j, sender, (EthAddress)address, this));
    }

    private CompilationResult.ContractMetadata compile(SoliditySource src, String contractName) throws IOException {
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])src.getSource().getBytes(EthereumFacade.CHARSET), (boolean)true, (SolidityCompiler.Options[])new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN});
        if (result.isFailed()) {
            throw new EthereumApiException("Contract compilation failed:\n" + result.errors);
        }
        CompilationResult res = CompilationResult.parse((String)result.output);
        if (res.contracts.isEmpty()) {
            throw new EthereumApiException("Compilation failed, no contracts returned:\n" + result.errors);
        }
        CompilationResult.ContractMetadata metadata = (CompilationResult.ContractMetadata)res.contracts.get(contractName);
        if (metadata != null && (metadata.bin == null || metadata.bin.isEmpty())) {
            throw new EthereumApiException("Compilation failed, no binary returned:\n" + result.errors);
        }
        return metadata;
    }

    private TransactionReceipt waitForTransactionReceipt(String transactionHash) {
        return this.getTransactionReceipt(transactionHash, 5000, 120).orElseThrow(() -> new EthereumApiException("Transaction reciept not generated after 120 attempts"));
    }

    private Optional<TransactionReceipt> getTransactionReceipt(String transactionHash, int sleepDuration, int attempts) {
        Optional<TransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts && !receiptOptional.isPresent(); ++i) {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException e) {
                throw new EthereumApiException("error while waiting for the transaction receipt", e);
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        return receiptOptional;
    }

    private Optional<TransactionReceipt> sendTransactionReceiptRequest(String transactionHash) {
        try {
            EthGetTransactionReceipt transactionReceipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).sendAsync().get();
            return transactionReceipt.getTransactionReceipt();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new EthereumApiException("error while waiting for the transaction receipt", e);
        }
    }

    @Override
    public CompletableFuture<EthExecutionResult> sendTx(EthValue value, EthData data, EthAccount sender, EthAddress toAddress) {
        EthGasPrice gasPrice;
        EthEstimateGas gas;
        EthGetTransactionCount nonce;
        EthAddress senderAddress = sender.getAddress();
        try {
            nonce = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(senderAddress.withLeading0x(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
            gas = (EthEstimateGas)this.web3j.ethEstimateGas(org.web3j.protocol.core.methods.request.Transaction.createEthCallTransaction((String)senderAddress.withLeading0x(), (String)data.toString())).send();
            gasPrice = (EthGasPrice)this.web3j.ethGasPrice().send();
        }
        catch (IOException e) {
            throw new EthereumApiException("error while sending a transaction", e);
        }
        this.increasePendingTransactionCounter(sender);
        Transaction tx = new Transaction(ByteUtil.bigIntegerToBytes((BigInteger)this.getNonce(sender, nonce)), ByteUtil.longToBytesNoLeadZeroes((long)gasPrice.getGasPrice().longValue()), ByteUtil.longToBytesNoLeadZeroes((long)gas.getAmountUsed().longValue()), (byte[])Optional.ofNullable(toAddress).map(addr -> addr.address).orElse(null), ByteUtil.longToBytesNoLeadZeroes((long)value.inWei().longValue()), data.data);
        tx.sign(sender.key);
        return ((CompletableFuture)this.web3j.ethSendRawTransaction(EthData.of(tx.getEncoded()).withLeading0x()).sendAsync().thenApply(this::handleTransaction)).thenApply(receipt -> {
            this.decreasePendingTransactionCounter(sender);
            return new EthExecutionResult(new byte[0]);
        });
    }

    private BigInteger getNonce(EthAccount account, EthGetTransactionCount nonce) {
        return nonce.getTransactionCount().add(this.pendingTransactions.getOrDefault(account, BigInteger.ZERO)).subtract(BigInteger.ONE);
    }

    @Override
    public CompletableFuture<EthAddress> sendTx(EthValue ethValue, EthData data, EthAccount sender) {
        EthGetTransactionCount nonce;
        EthAddress senderAddress = sender.getAddress();
        try {
            nonce = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(senderAddress.withLeading0x(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        }
        catch (IOException e) {
            throw new EthereumApiException("error while getting the nonce", e);
        }
        this.increasePendingTransactionCounter(sender);
        return ((CompletableFuture)((CompletableFuture)this.web3j.ethEstimateGas(org.web3j.protocol.core.methods.request.Transaction.createContractTransaction((String)senderAddress.withLeading0x(), (BigInteger)nonce.getTransactionCount(), (BigInteger)BigInteger.ZERO, (String)data.toString())).sendAsync().thenCompose(gas -> this.web3j.ethGasPrice().sendAsync().thenCompose(price -> {
            RawTransaction tx = RawTransaction.createContractTransaction((BigInteger)this.getNonce(sender, nonce), (BigInteger)price.getGasPrice(), (BigInteger)gas.getAmountUsed().add(BigInteger.valueOf(100000L)), (BigInteger)ethValue.inWei(), (String)data.toString());
            EthData signedTx = EthData.of(TransactionEncoder.signMessage((RawTransaction)tx, (Credentials)sender.credentials));
            return this.web3j.ethSendRawTransaction(signedTx.toString()).sendAsync();
        }))).thenApply(this::handleTransaction)).thenApply(receipt -> {
            this.decreasePendingTransactionCounter(sender);
            return EthAddress.of(receipt.getContractAddress().orElse(null));
        });
    }

    private TransactionReceipt handleTransaction(EthSendTransaction result) {
        if (result.hasError()) {
            throw new EthereumApiException(result.getError().getMessage());
        }
        log.info("transaction " + result.getTransactionHash() + " has been sent. Waiting to be mined");
        return this.waitForTransactionReceipt(result.getTransactionHash());
    }

    @Override
    public EthereumEventHandler events() {
        throw new EthereumApiException("event handling is not yet implemented for RPC");
    }

    @Override
    public boolean addressExists(EthAddress address) {
        throw new EthereumApiException("addressExists is not implemented for RPC");
    }

    @Override
    public EthValue getBalance(EthAddress address) {
        try {
            EthGetBalance result = (EthGetBalance)this.web3j.ethGetBalance(address.withLeading0x(), DefaultBlockParameter.valueOf((String)"latest")).send();
            if (result.hasError()) {
                throw new EthereumApiException(result.getError().getMessage());
            }
            return EthValue.wei(result.getBalance());
        }
        catch (IOException e) {
            throw new EthereumApiException("error while getting the balance", e);
        }
    }

    private void decreasePendingTransactionCounter(EthAccount sender) {
        this.pendingTransactions.put(sender, this.pendingTransactions.getOrDefault(sender, BigInteger.ZERO).subtract(BigInteger.ONE));
    }

    private void increasePendingTransactionCounter(EthAccount sender) {
        this.pendingTransactions.put(sender, this.pendingTransactions.getOrDefault(sender, BigInteger.ZERO).add(BigInteger.ONE));
    }
}

