/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.converters.output;

import java.math.BigInteger;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.values.EthAddress;

public class AddressHandler
implements OutputTypeHandler<EthAddress> {
    @Override
    public boolean isOfType(Class<?> cls) {
        return EthAddress.class.equals(cls);
    }

    @Override
    public EthAddress convert(Object obj, Class<?> cls) {
        if (obj.getClass().equals(BigInteger.class)) {
            BigInteger bint = (BigInteger)obj;
            byte[] barray = bint.toByteArray();
            byte[] address = new byte[barray.length - 1];
            System.arraycopy(barray, 1, address, 0, address.length);
            return EthAddress.of(address);
        }
        try {
            return EthAddress.of((byte[])obj);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot convert " + obj.getClass().getSimpleName() + " to Address");
        }
    }
}

