/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainProxyReal;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.keystore.FileSecureKey;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.provider.EthereumFacadeProvider;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.facade.Ethereum;
import org.ethereum.facade.EthereumFactory;
import org.web3j.crypto.WalletUtils;

public class MainEthereumFacadeProvider
implements EthereumFacadeProvider {
    @Override
    public EthereumFacade create() {
        return this.create(new OnBlockHandler(), new OnTransactionHandler());
    }

    @Override
    public EthereumFacade create(OnBlockHandler onBlockHandler, OnTransactionHandler onTransactionHandler) {
        Ethereum ethereum = EthereumFactory.createEthereum();
        EthereumEventHandler ethereumListener = new EthereumEventHandler(ethereum, onBlockHandler, onTransactionHandler);
        ethereum.init();
        return new EthereumFacade(new BlockchainProxyReal(ethereum, ethereumListener));
    }

    @Override
    public SecureKey getKey(String id) throws Exception {
        File[] files = new File(this.getKeystoreFolderPath()).listFiles();
        return Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)files, (Object)("the folder " + this.getKeystoreFolderPath() + " cannot be found")))).stream().filter(file -> id.equals(file.getName())).findFirst().map(FileSecureKey::new).orElseThrow(() -> new EthereumApiException("the file " + id + " could not be found"));
    }

    @Override
    public List<? extends SecureKey> listAvailableKeys() {
        Object[] files = Optional.ofNullable(new File(this.getKeystoreFolderPath()).listFiles()).orElseThrow(() -> new EthereumApiException("cannot find the folder " + this.getKeystoreFolderPath()));
        return Lists.newArrayList((Object[])files).stream().filter(File::isFile).map(FileSecureKey::new).collect(Collectors.toList());
    }

    private String getKeystoreFolderPath() {
        return WalletUtils.getMainnetKeyDirectory();
    }
}

