/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.google.common.collect.Lists;
import com.typesafe.config.ConfigFactory;
import java.util.List;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainProxyReal;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.keystore.StringSecureKey;
import org.adridadou.ethereum.provider.EthereumFacadeProvider;
import org.ethereum.config.SystemProperties;
import org.ethereum.facade.Ethereum;
import org.ethereum.facade.EthereumFactory;
import org.springframework.context.annotation.Bean;

public class TestnetEthereumFacadeProvider
implements EthereumFacadeProvider {
    @Override
    public EthereumFacade create() {
        return this.create(new OnBlockHandler(), new OnTransactionHandler());
    }

    @Override
    public EthereumFacade create(OnBlockHandler onBlockHandler, OnTransactionHandler onTransactionHandler) {
        Ethereum ethereum = EthereumFactory.createEthereum(TestNetConfig.class);
        EthereumEventHandler ethereumListener = new EthereumEventHandler(ethereum, onBlockHandler, onTransactionHandler);
        ethereum.init();
        return new EthereumFacade(new BlockchainProxyReal(ethereum, ethereumListener));
    }

    @Override
    public List<? extends SecureKey> listAvailableKeys() {
        return Lists.newArrayList((Object[])new SecureKey[]{this.getKey("cow"), this.getKey("bull"), this.getKey("frog"), this.getKey("lion")});
    }

    @Override
    public SecureKey getKey(String id) {
        return new StringSecureKey(id);
    }

    private static class TestNetConfig {
        private final String testNetConfig = "peer.discovery.enabled = false \npeer.listen.port = 0 \npeer.networkId = 161 \npeer.active = [    { url = 'enode://9bcff30ea776ebd28a9424d0ac7aa500d372f918445788f45a807d83186bd52c4c0afaf504d77e2077e5a99f1f264f75f8738646c1ac3673ccc652b65565c3bb@peer-1.ether.camp:30303' },    { url = 'enode://c2b35ed63f5d79c7f160d05c54dd60b3ba32d455dbb10a5fe6fde44854073db02f9a538423a63a480126c74c7f650d77066ae446258e3d00388401d419b99f88@peer-2.ether.camp:30303' },    { url = 'enode://8246787f8d57662b850b354f0b526251eafee1f077fc709460dc8788fa640a597e49ffc727580f3ebbbc5eacb34436a66ea40415fab9d73563481666090a6cf0@peer-3.ether.camp:30303' }] \nsync.enabled = true \ngenesis = frontier-test.json \ndatabase.dir = testnetSampleDb \ncache.flush.memory = 0 \npeer.p2p.eip8 = false";

        private TestNetConfig() {
        }

        @Bean
        public SystemProperties systemProperties() {
            SystemProperties props = new SystemProperties();
            props.overrideParams(ConfigFactory.parseString((String)"peer.discovery.enabled = false \npeer.listen.port = 0 \npeer.networkId = 161 \npeer.active = [    { url = 'enode://9bcff30ea776ebd28a9424d0ac7aa500d372f918445788f45a807d83186bd52c4c0afaf504d77e2077e5a99f1f264f75f8738646c1ac3673ccc652b65565c3bb@peer-1.ether.camp:30303' },    { url = 'enode://c2b35ed63f5d79c7f160d05c54dd60b3ba32d455dbb10a5fe6fde44854073db02f9a538423a63a480126c74c7f650d77066ae446258e3d00388401d419b99f88@peer-2.ether.camp:30303' },    { url = 'enode://8246787f8d57662b850b354f0b526251eafee1f077fc709460dc8788fa640a597e49ffc727580f3ebbbc5eacb34436a66ea40415fab9d73563481666090a6cf0@peer-3.ether.camp:30303' }] \nsync.enabled = true \ngenesis = frontier-test.json \ndatabase.dir = testnetSampleDb \ncache.flush.memory = 0 \npeer.p2p.eip8 = false".replaceAll("'", "\"")));
            return props;
        }
    }
}

