/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.smartcontract;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.blockchain.BlockchainProxyRpc;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;

public class SmartContractRpc
implements SmartContract {
    private EthAddress address;
    private CallTransaction.Contract contract;
    private final Web3j web3j;
    private final BlockchainProxyRpc bcProxy;
    private final EthAccount sender;
    private final EthAddress senderAddress;

    public SmartContractRpc(String abi, Web3j web3j, EthAccount sender, EthAddress address, BlockchainProxyRpc bcProxy) {
        this.contract = new CallTransaction.Contract(abi);
        this.web3j = web3j;
        this.sender = sender;
        this.bcProxy = bcProxy;
        this.address = address;
        this.senderAddress = sender.getAddress();
    }

    @Override
    public List<CallTransaction.Function> getFunctions() {
        return Lists.newArrayList((Object[])this.contract.functions);
    }

    @Override
    public Object[] callConstFunction(String functionName, Object ... args) {
        return Optional.ofNullable(this.contract.getByName(functionName)).map(func -> {
            try {
                EthCall result = (EthCall)this.web3j.ethCall(new Transaction(this.senderAddress.withLeading0x(), BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(1000000000L), this.address.withLeading0x(), BigInteger.ZERO, EthData.of(func.encode(args)).toString()), DefaultBlockParameter.valueOf((String)"latest")).send();
                if (result.hasError()) {
                    throw new EthereumApiException(result.getError().getMessage());
                }
                return func.decodeResult(EthData.of((String)result.getValue()).data);
            }
            catch (IOException e) {
                throw new EthereumApiException("error while calling a constant function");
            }
        }).orElseThrow(() -> new EthereumApiException("function " + functionName + " cannot be found. available:" + this.getAvailableFunctions()));
    }

    @Override
    public CompletableFuture<Object[]> callFunction(String functionName, Object ... args) {
        return this.callFunction(EthValue.wei(0), functionName, args);
    }

    public CompletableFuture<Object[]> callFunction(EthValue value, String functionName, Object ... args) {
        return Optional.ofNullable(this.contract.getByName(functionName)).map(func -> this.bcProxy.sendTx(value, EthData.of(func.encode(args)), this.sender, this.address).thenApply(receipt -> Optional.ofNullable(receipt.getResult()).map(result -> this.contract.getByName(functionName).decodeResult(result)).orElse(null))).orElseThrow(() -> new EthereumApiException("function " + functionName + " cannot be found. available:" + this.getAvailableFunctions()));
    }

    private String getAvailableFunctions() {
        ArrayList<String> names = new ArrayList<String>();
        for (CallTransaction.Function func : this.contract.functions) {
            names.add(func.name);
        }
        return ((Object)names).toString();
    }

    public EthAddress getAddress() {
        return this.address;
    }
}

