/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.adridadou.ethereum.EthereumFacade;
import org.apache.commons.io.IOUtils;

public class SoliditySource {
    private final String source;

    public SoliditySource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public static SoliditySource from(File file) {
        try {
            return SoliditySource.from(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static SoliditySource from(InputStream file) {
        try {
            return new SoliditySource(IOUtils.toString((InputStream)file, (Charset)EthereumFacade.CHARSET));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoliditySource that = (SoliditySource)o;
        return this.source != null ? this.source.equals(that.source) : that.source == null;
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }

    public String toString() {
        return "source:" + this.source;
    }
}

