/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.ProxyWrapper;
import org.adridadou.ethereum.blockchain.BlockchainProxy;
import org.adridadou.ethereum.converters.input.InputTypeHandler;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.SmartContractInfo;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.exception.ContractNotFoundException;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;

public class EthereumContractInvocationHandler
implements InvocationHandler {
    private final Map<EthAddress, Map<EthAccount, SmartContract>> contracts = new HashMap<EthAddress, Map<EthAccount, SmartContract>>();
    private final BlockchainProxy blockchainProxy;
    private final InputTypeHandler inputTypeHandler;
    private final OutputTypeHandler outputTypeHandler;
    private final Map<ProxyWrapper, SmartContractInfo> info = new HashMap<ProxyWrapper, SmartContractInfo>();

    EthereumContractInvocationHandler(BlockchainProxy blockchainProxy, InputTypeHandler inputTypeHandler, OutputTypeHandler outputTypeHandler) {
        this.blockchainProxy = blockchainProxy;
        this.inputTypeHandler = inputTypeHandler;
        this.outputTypeHandler = outputTypeHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        SmartContractInfo contractInfo = this.info.get(new ProxyWrapper(proxy));
        SmartContract contract = this.contracts.get(contractInfo.getAddress()).get(contractInfo.getSender());
        Object[] arguments = Optional.ofNullable(args).map(this::prepareArguments).orElse(new Object[0]);
        if (method.getReturnType().equals(Void.TYPE)) {
            try {
                contract.callFunction(methodName, arguments).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            return Void.TYPE;
        }
        if (method.getReturnType().equals(CompletableFuture.class)) {
            return contract.callFunction(methodName, arguments).thenApply(result -> this.convertResult((Object[])result, method));
        }
        return this.convertResult(contract.callConstFunction(methodName, arguments), method);
    }

    private Object[] prepareArguments(Object[] args) {
        return Arrays.stream(args).map(this.inputTypeHandler::convert).toArray();
    }

    private Object convertResult(Object[] result, Method method) {
        if (result.length == 0) {
            return this.convertResult(null, method.getReturnType(), method.getGenericReturnType());
        }
        if (result.length == 1) {
            return this.convertResult(result[0], method.getReturnType(), method.getGenericReturnType());
        }
        return this.convertSpecificType(result, method.getReturnType());
    }

    private Object convertSpecificType(Object[] result, Class<?> returnType) {
        Object[] params = new Object[result.length];
        Constructor constr = this.lookForNonEmptyConstructor(returnType, result);
        for (int i = 0; i < result.length; ++i) {
            params[i] = this.convertResult(result[i], constr.getParameterTypes()[i], constr.getGenericParameterTypes()[i]);
        }
        try {
            return constr.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EthereumApiException("error while converting to a specific type", e);
        }
    }

    private Object convertResult(Object result, Class<?> returnType, Type genericType) {
        return this.outputTypeHandler.getConverter(returnType).map(converter -> converter.convert(result, returnType.isArray() ? returnType.getComponentType() : genericType)).orElseGet(() -> this.convertSpecificType(new Object[]{result}, returnType));
    }

    private Constructor lookForNonEmptyConstructor(Class<?> returnType, Object[] result) {
        for (Constructor<?> constructor : returnType.getConstructors()) {
            if (constructor.getParameterCount() <= 0) continue;
            if (constructor.getParameterCount() != result.length) {
                throw new IllegalArgumentException("the number of arguments don't match for type " + returnType.getSimpleName() + ". Constructor has " + constructor.getParameterCount() + " and result has " + result.length);
            }
            return constructor;
        }
        throw new IllegalArgumentException("no constructor with arguments found! for type " + returnType.getSimpleName());
    }

    <T> void register(T proxy, Class<T> contractInterface, SoliditySource code, String contractName, EthAddress address, EthAccount sender) throws IOException {
        Map contractsFound = this.compile((String)code.getSource()).contracts;
        CompilationResult.ContractMetadata found = null;
        for (Map.Entry entry : contractsFound.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(contractName)) continue;
            if (found != null) {
                throw new EthereumApiException("more than one Contract found for " + contractInterface.getSimpleName());
            }
            found = (CompilationResult.ContractMetadata)entry.getValue();
        }
        if (found == null) {
            throw new ContractNotFoundException("no contract found for " + contractInterface.getSimpleName());
        }
        SmartContract smartContract = this.blockchainProxy.map(code, contractName, address, sender);
        this.verifyContract(smartContract, contractInterface);
        this.info.put(new ProxyWrapper(proxy), new SmartContractInfo(address, sender));
        Map proxies = this.contracts.getOrDefault(address, new HashMap());
        proxies.put(sender, smartContract);
        this.contracts.put(address, proxies);
    }

    <T> void register(T proxy, Class<T> contractInterface, ContractAbi abi, EthAddress address, EthAccount sender) {
        SmartContract smartContract = this.blockchainProxy.mapFromAbi(abi, address, sender);
        this.verifyContract(smartContract, contractInterface);
        this.info.put(new ProxyWrapper(proxy), new SmartContractInfo(address, sender));
        Map proxies = this.contracts.getOrDefault(address, new HashMap());
        proxies.put(sender, smartContract);
        this.contracts.put(address, proxies);
    }

    private void verifyContract(SmartContract smartContract, Class<?> contractInterface) {
        Set solidityFuncNames;
        HashSet interfaceMethods = Sets.newHashSet((Object[])contractInterface.getMethods());
        Set solidityMethods = smartContract.getFunctions().stream().filter(f -> f != null).collect(Collectors.toSet());
        Set interfaceMethodNames = interfaceMethods.stream().map(Method::getName).collect(Collectors.toSet());
        Sets.SetView superfluous = Sets.difference(interfaceMethodNames, solidityFuncNames = solidityMethods.stream().map(d -> d.name).collect(Collectors.toSet()));
        if (!superfluous.isEmpty()) {
            throw new EthereumApiException("superflous function definition in interface " + contractInterface.getName() + ":" + superfluous.toString());
        }
        Map methods = interfaceMethods.stream().collect(Collectors.toMap(Method::getName, Function.identity()));
        for (CallTransaction.Function func : solidityMethods) {
            if (methods.get(func.name) == null || func.inputs.length == ((Method)methods.get(func.name)).getParameterCount()) continue;
            throw new EthereumApiException("parameter count mismatch for " + func.name + " on contract " + contractInterface.getName());
        }
    }

    private CompilationResult compile(String contract) throws IOException {
        SolidityCompiler.Result res = SolidityCompiler.compile((byte[])contract.getBytes(EthereumFacade.CHARSET), (boolean)true, (SolidityCompiler.Options[])new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE});
        return CompilationResult.parse((String)res.output);
    }
}

