/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.EthereumContractInvocationHandler;
import org.adridadou.ethereum.blockchain.BlockchainProxy;
import org.adridadou.ethereum.converters.input.InputTypeConverter;
import org.adridadou.ethereum.converters.input.InputTypeHandler;
import org.adridadou.ethereum.converters.output.OutputTypeConverter;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SoliditySource;

public class EthereumFacade {
    public static final Charset CHARSET = Charsets.UTF_8;
    private final EthereumContractInvocationHandler handler;
    private final OutputTypeHandler outputTypeHandler;
    private final InputTypeHandler inputTypeHandler = new InputTypeHandler();
    private final BlockchainProxy blockchainProxy;

    public EthereumFacade(BlockchainProxy blockchainProxy) {
        this.outputTypeHandler = new OutputTypeHandler();
        this.handler = new EthereumContractInvocationHandler(blockchainProxy, this.inputTypeHandler, this.outputTypeHandler);
        this.blockchainProxy = blockchainProxy;
    }

    public EthereumFacade addInputHandlers(List<InputTypeConverter<?>> handlers) {
        this.inputTypeHandler.addConverters(handlers);
        return this;
    }

    public EthereumFacade addOutputHandlers(List<OutputTypeConverter> handlers) {
        this.outputTypeHandler.addConverters(handlers);
        return this;
    }

    public <T> T createContractProxy(SoliditySource code, String contractName, EthAddress address, EthAccount sender, Class<T> contractInterface) throws IOException {
        Object proxy = Proxy.newProxyInstance(contractInterface.getClassLoader(), new Class[]{contractInterface}, (InvocationHandler)this.handler);
        this.handler.register(proxy, contractInterface, code, contractName, address, sender);
        return (T)proxy;
    }

    public <T> T createContractProxy(ContractAbi abi, EthAddress address, EthAccount sender, Class<T> contractInterface) throws IOException {
        Object proxy = Proxy.newProxyInstance(contractInterface.getClassLoader(), new Class[]{contractInterface}, (InvocationHandler)this.handler);
        this.handler.register(proxy, contractInterface, abi, address, sender);
        return (T)proxy;
    }

    public CompletableFuture<EthAddress> publishContract(SoliditySource code, String contractName, EthAccount sender, Object ... constructorArgs) {
        return this.blockchainProxy.publish(code, contractName, sender, constructorArgs);
    }

    public boolean addressExists(EthAddress address) {
        return this.blockchainProxy.addressExists(address);
    }

    public EthValue getBalance(EthAddress addr) {
        return this.blockchainProxy.getBalance(addr);
    }

    public EthValue getBalance(EthAccount account) {
        return this.blockchainProxy.getBalance(account.getAddress());
    }

    public EthereumEventHandler events() {
        return this.blockchainProxy.events();
    }

    public CompletableFuture<EthExecutionResult> sendEther(EthAccount fromAccount, EthAddress to, EthValue value) {
        return this.blockchainProxy.sendTx(value, EthData.empty(), fromAccount, to);
    }

    public BigInteger getNonce(EthAddress address) {
        return this.blockchainProxy.getNonce(address);
    }
}

