/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainProxy;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractReal;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.facade.Ethereum;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.CopyOnWriteMap;
import org.spongycastle.util.encoders.Hex;

public class BlockchainProxyReal
implements BlockchainProxy {
    private static final long BLOCK_WAIT_LIMIT = 16L;
    private final Ethereum ethereum;
    private final EthereumEventHandler eventHandler;
    private final Map<EthAddress, BigInteger> pendingTransactions = new CopyOnWriteMap();

    public BlockchainProxyReal(Ethereum ethereum, EthereumEventHandler eventHandler) {
        this.ethereum = ethereum;
        this.eventHandler = eventHandler;
        eventHandler.onReady().thenAccept(b -> ethereum.getBlockchain().flush());
    }

    @Override
    public SmartContract map(SoliditySource src, String contractName, EthAddress address, EthAccount sender) {
        try {
            CompilationResult.ContractMetadata metadata = this.compile(src, contractName);
            return this.mapFromAbi(new ContractAbi(metadata.abi), address, sender);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while mapping a smart contract", e);
        }
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, EthAccount sender) {
        return new SmartContractReal(abi.getAbi(), this.ethereum, sender, address, this);
    }

    @Override
    public CompletableFuture<EthAddress> publish(SoliditySource code, String contractName, EthAccount sender, Object ... constructorArgs) {
        try {
            return this.createContract(code, contractName, sender, constructorArgs).thenApply(SmartContractReal::getAddress);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while publishing " + contractName + ":", e);
        }
    }

    private CompletableFuture<SmartContractReal> createContract(SoliditySource soliditySrc, String contractName, EthAccount sender, Object ... constructorArgs) throws IOException {
        CompilationResult.ContractMetadata metadata = this.compile(soliditySrc, contractName);
        CallTransaction.Contract contract = new CallTransaction.Contract(metadata.abi);
        CallTransaction.Function constructor = contract.getConstructor();
        if (constructor == null && constructorArgs.length > 0) {
            throw new EthereumApiException("No constructor with params found");
        }
        byte[] argsEncoded = constructor == null ? new byte[]{} : constructor.encodeArguments(constructorArgs);
        return this.sendTx(EthValue.wei(0), EthData.of(ByteUtil.merge((byte[][])new byte[][]{Hex.decode((String)metadata.bin), argsEncoded})), sender).thenApply(address -> new SmartContractReal(metadata.abi, this.ethereum, sender, (EthAddress)address, this));
    }

    private CompilationResult.ContractMetadata compile(SoliditySource src, String contractName) throws IOException {
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])src.getSource().getBytes(EthereumFacade.CHARSET), (boolean)true, (SolidityCompiler.Options[])new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN});
        if (result.isFailed()) {
            throw new EthereumApiException("Contract compilation failed:\n" + result.errors);
        }
        CompilationResult res = CompilationResult.parse((String)result.output);
        if (res.contracts.isEmpty()) {
            throw new EthereumApiException("Compilation failed, no contracts returned:\n" + result.errors);
        }
        CompilationResult.ContractMetadata metadata = (CompilationResult.ContractMetadata)res.contracts.get(contractName);
        if (metadata != null && (metadata.bin == null || metadata.bin.isEmpty())) {
            throw new EthereumApiException("Compilation failed, no binary returned:\n" + result.errors);
        }
        return metadata;
    }

    @Override
    public BigInteger getNonce(EthAddress address) {
        BigInteger nonce = this.ethereum.getRepository().getNonce(address.address);
        return nonce.add(this.pendingTransactions.getOrDefault(address, BigInteger.ZERO));
    }

    @Override
    public CompletableFuture<EthAddress> sendTx(EthValue ethValue, EthData data, EthAccount sender) {
        return this.sendTxInternal(ethValue, data, sender, EthAddress.empty()).thenApply(receipt -> EthAddress.of(receipt.getTransaction().getContractAddress()));
    }

    @Override
    public CompletableFuture<EthExecutionResult> sendTx(EthValue value, EthData data, EthAccount sender, EthAddress address) {
        return this.sendTxInternal(value, data, sender, address).thenApply(receipt -> new EthExecutionResult(receipt.getExecutionResult()));
    }

    private CompletableFuture<TransactionReceipt> sendTxInternal(EthValue value, EthData data, EthAccount sender, EthAddress toAddress) {
        return this.eventHandler.onReady().thenCompose(b -> {
            BigInteger nonce = this.getNonce(sender.getAddress());
            Transaction tx = new Transaction(ByteUtil.bigIntegerToBytes((BigInteger)nonce), ByteUtil.longToBytesNoLeadZeroes((long)this.ethereum.getGasPrice()), ByteUtil.longToBytesNoLeadZeroes((long)3000000L), toAddress.address, ByteUtil.longToBytesNoLeadZeroes((long)value.inWei().longValue()), data.data, this.ethereum.getChainIdForNextBlock());
            tx.sign(sender.key);
            this.ethereum.submitTransaction(tx);
            this.increasePendingTransactionCounter(sender.getAddress());
            long currentBlock = this.eventHandler.getCurrentBlockNumber();
            Predicate<TransactionReceipt> findReceipt = receipt -> new ByteArrayWrapper(receipt.getTransaction().getHash()).equals((Object)new ByteArrayWrapper(tx.getHash()));
            return CompletableFuture.supplyAsync(() -> (TransactionReceipt)this.eventHandler.observeBlocks().filter(params -> params.receipts.stream().anyMatch(findReceipt) || params.block.getNumber() > currentBlock + 16L).map(params -> {
                Optional receipt = params.receipts.stream().filter(findReceipt).findFirst();
                this.decreasePendingTransactionCounter(sender.getAddress());
                return receipt.map(this.eventHandler::checkForErrors).orElseThrow(() -> new EthereumApiException("the transaction has not been added to any block after waiting for 16"));
            }).toBlocking().first());
        });
    }

    @Override
    public EthereumEventHandler events() {
        return this.eventHandler;
    }

    @Override
    public boolean addressExists(EthAddress address) {
        return this.ethereum.getRepository().isExist(address.address);
    }

    @Override
    public EthValue getBalance(EthAddress address) {
        return EthValue.wei(this.ethereum.getRepository().getBalance(address.address));
    }

    private void decreasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).subtract(BigInteger.ONE));
    }

    private void increasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).add(BigInteger.ONE));
    }
}

