/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainProxy;
import org.adridadou.ethereum.blockchain.Web3JFacade;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractRpc;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.ethereum.values.config.ChainId;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Transaction;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.core.methods.request.RawTransaction;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class BlockchainProxyRpc
implements BlockchainProxy {
    private static final int SLEEP_DURATION = 5000;
    private static final int ATTEMPTS = 120;
    private static final Logger log = LoggerFactory.getLogger(BlockchainProxyRpc.class);
    private final Map<EthAddress, BigInteger> pendingTransactions = new CopyOnWriteMap();
    private final ChainId chainId;
    private final Web3JFacade web3JFacade;

    public BlockchainProxyRpc(Web3JFacade web3jFacade, ChainId chainId) {
        this.web3JFacade = web3jFacade;
        this.chainId = chainId;
    }

    @Override
    public SmartContract map(SoliditySource src, String contractName, EthAddress address, EthAccount sender) {
        try {
            CompilationResult.ContractMetadata metadata = this.compile(src, contractName);
            return this.mapFromAbi(new ContractAbi(metadata.abi), address, sender);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while mapping a smart contract", e);
        }
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, EthAccount sender) {
        return new SmartContractRpc(abi.getAbi(), this.web3JFacade, sender, address, this);
    }

    @Override
    public CompletableFuture<EthAddress> publish(SoliditySource code, String contractName, EthAccount sender, Object ... constructorArgs) {
        try {
            return this.createContract(code, contractName, sender, constructorArgs).thenApply(SmartContractRpc::getAddress);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while publishing " + contractName + ":", e);
        }
    }

    private CompletableFuture<SmartContractRpc> createContract(SoliditySource soliditySrc, String contractName, EthAccount sender, Object ... constructorArgs) throws IOException {
        CompilationResult.ContractMetadata metadata = this.compile(soliditySrc, contractName);
        CallTransaction.Contract contract = new CallTransaction.Contract(metadata.abi);
        CallTransaction.Function constructor = contract.getConstructor();
        if (constructor == null && constructorArgs.length > 0) {
            throw new EthereumApiException("No constructor with params found");
        }
        byte[] argsEncoded = constructor == null ? new byte[]{} : constructor.encodeArguments(constructorArgs);
        return this.sendTx(EthValue.wei(0), EthData.of(ByteUtil.merge((byte[][])new byte[][]{Hex.decode((String)metadata.bin), argsEncoded})), sender).thenApply(address -> new SmartContractRpc(metadata.abi, this.web3JFacade, sender, (EthAddress)address, this));
    }

    private CompilationResult.ContractMetadata compile(SoliditySource src, String contractName) throws IOException {
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])src.getSource().getBytes(EthereumFacade.CHARSET), (boolean)true, (SolidityCompiler.Options[])new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN});
        if (result.isFailed()) {
            throw new EthereumApiException("Contract compilation failed:\n" + result.errors);
        }
        CompilationResult res = CompilationResult.parse((String)result.output);
        if (res.contracts.isEmpty()) {
            throw new EthereumApiException("Compilation failed, no contracts returned:\n" + result.errors);
        }
        CompilationResult.ContractMetadata metadata = (CompilationResult.ContractMetadata)res.contracts.get(contractName);
        if (metadata != null && (metadata.bin == null || metadata.bin.isEmpty())) {
            throw new EthereumApiException("Compilation failed, no binary returned:\n" + result.errors);
        }
        return metadata;
    }

    private CompletableFuture<TransactionReceipt> waitForTransactionReceipt(EthData transactionHash) {
        return CompletableFuture.supplyAsync(() -> this.getTransactionReceipt(transactionHash, 5000, 120).orElseThrow(() -> new EthereumApiException("Transaction reciept not generated after 120 attempts")));
    }

    private Optional<TransactionReceipt> getTransactionReceipt(EthData transactionHash, int sleepDuration, int attempts) {
        Optional<TransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts && !receiptOptional.isPresent(); ++i) {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException e) {
                throw new EthereumApiException("error while waiting for the transaction receipt", e);
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        return receiptOptional;
    }

    private Optional<TransactionReceipt> sendTransactionReceiptRequest(EthData transactionHash) {
        return Optional.ofNullable(this.web3JFacade.getTransactionReceipt(transactionHash));
    }

    @Override
    public CompletableFuture<EthExecutionResult> sendTx(EthValue value, EthData data, EthAccount sender, EthAddress toAddress) {
        BigInteger gas = this.web3JFacade.estimateGas(sender, data);
        BigInteger gasPrice = this.web3JFacade.getGasPrice();
        this.increasePendingTransactionCounter(sender.getAddress());
        Transaction tx = new Transaction(ByteUtil.bigIntegerToBytes((BigInteger)this.getNonce(sender.getAddress())), ByteUtil.longToBytesNoLeadZeroes((long)gasPrice.longValue()), ByteUtil.longToBytesNoLeadZeroes((long)gas.longValue()), (byte[])Optional.ofNullable(toAddress).map(addr -> addr.address).orElse(null), ByteUtil.longToBytesNoLeadZeroes((long)value.inWei().longValue()), data.data, Byte.valueOf((byte)this.chainId.id));
        tx.sign(sender.key);
        return CompletableFuture.supplyAsync(() -> {
            this.web3JFacade.sendTransaction(EthData.of(tx.getEncoded()));
            this.decreasePendingTransactionCounter(sender.getAddress());
            return new EthExecutionResult(new byte[0]);
        });
    }

    @Override
    public BigInteger getNonce(EthAddress address) {
        return this.web3JFacade.getTransactionCount(address).add(this.pendingTransactions.getOrDefault(address, BigInteger.ZERO)).subtract(BigInteger.ONE);
    }

    @Override
    public CompletableFuture<EthAddress> sendTx(EthValue ethValue, EthData data, EthAccount sender) {
        BigInteger gas = this.web3JFacade.estimateGas(sender, data);
        BigInteger gasPrice = this.web3JFacade.getGasPrice();
        this.increasePendingTransactionCounter(sender.getAddress());
        RawTransaction tx = RawTransaction.createContractTransaction((BigInteger)this.getNonce(sender.getAddress()), (BigInteger)gasPrice, (BigInteger)gas.add(BigInteger.valueOf(100000L)), (BigInteger)ethValue.inWei(), (String)data.toString());
        EthData signedTx = EthData.of(TransactionEncoder.signMessage((RawTransaction)tx, (Credentials)sender.credentials));
        EthData result = this.web3JFacade.sendTransaction(signedTx);
        return this.handleTransaction(result).thenApply(receipt -> {
            this.decreasePendingTransactionCounter(sender.getAddress());
            return EthAddress.of(receipt.getContractAddress().orElse(null));
        });
    }

    private CompletableFuture<TransactionReceipt> handleTransaction(EthData result) {
        log.info("transaction " + result.toString() + " has been sent. Waiting to be mined");
        return this.waitForTransactionReceipt(result);
    }

    @Override
    public EthereumEventHandler events() {
        throw new EthereumApiException("event handling is not yet implemented for RPC");
    }

    @Override
    public boolean addressExists(EthAddress address) {
        throw new EthereumApiException("addressExists is not implemented for RPC");
    }

    @Override
    public EthValue getBalance(EthAddress address) {
        EthGetBalance result = this.web3JFacade.getBalance(address);
        if (result.hasError()) {
            throw new EthereumApiException(result.getError().getMessage());
        }
        return EthValue.wei(result.getBalance());
    }

    private void decreasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).subtract(BigInteger.ONE));
    }

    private void increasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).add(BigInteger.ONE));
    }
}

