/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.io.IOError;
import java.io.IOException;
import java.math.BigInteger;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.exception.EthereumApiException;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class Web3JFacade {
    private final Web3j web3j;

    public Web3JFacade(Web3j web3j) {
        this.web3j = web3j;
    }

    public EthData constantCall(EthAccount sender, EthAddress address, EthData data) {
        try {
            return EthData.of((String)this.handleError(this.web3j.ethCall(new Transaction(sender.getAddress().withLeading0x(), BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(1000000000L), address.withLeading0x(), BigInteger.ZERO, data.toString()), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public TransactionReceipt getTransactionReceipt(EthData transactionHash) {
        try {
            return (TransactionReceipt)this.handleError(this.web3j.ethGetTransactionReceipt(transactionHash.withLeading0x()).send());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public BigInteger getTransactionCount(EthAddress address) {
        try {
            return Numeric.decodeQuantity((String)((String)this.handleError(this.web3j.ethGetTransactionCount(address.withLeading0x(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send())));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public BigInteger estimateGas(EthAccount sender, EthData data) {
        try {
            return Numeric.decodeQuantity((String)((String)this.handleError(this.web3j.ethEstimateGas(Transaction.createEthCallTransaction((String)sender.getAddress().withLeading0x(), (String)data.toString())).send())));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public BigInteger getGasPrice() {
        try {
            return Numeric.decodeQuantity((String)((String)this.handleError(this.web3j.ethGasPrice().send())));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public EthData sendTransaction(EthData rawTransaction) {
        try {
            return EthData.of((String)this.handleError(this.web3j.ethSendRawTransaction(rawTransaction.withLeading0x()).send()));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public EthGetBalance getBalance(EthAddress address) {
        try {
            return (EthGetBalance)this.web3j.ethGetBalance(address.withLeading0x(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private <S, T extends Response<S>> S handleError(T response) {
        if (response.hasError()) {
            throw new EthereumApiException(response.getError().getMessage());
        }
        return (S)response.getResult();
    }
}

