/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.converters.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.adridadou.ethereum.converters.input.EthAccountConverter;
import org.adridadou.ethereum.converters.input.EthAddressConverter;
import org.adridadou.ethereum.converters.input.EthDataConverter;
import org.adridadou.ethereum.converters.input.EthValueConverter;
import org.adridadou.ethereum.converters.input.InputTypeConverter;

public class InputTypeHandler {
    public static final List<InputTypeConverter<?>> JAVA_INPUT_CONVERTERS = ImmutableList.builder().add((Object[])new InputTypeConverter[]{new EthAddressConverter(), new EthAccountConverter(), new EthDataConverter(), new EthValueConverter()}).build();
    private final List<InputTypeConverter<?>> inputConverters = new ArrayList();

    public InputTypeHandler() {
        this.addConverters(JAVA_INPUT_CONVERTERS);
    }

    public void addConverters(InputTypeConverter<?> ... converters) {
        this.addConverters(Lists.newArrayList((Object[])converters));
    }

    public void addConverters(Collection<InputTypeConverter<?>> converters) {
        this.inputConverters.addAll(converters);
    }

    public Optional<InputTypeConverter<?>> getConverter(Class<?> cls) {
        return this.inputConverters.stream().filter(converter -> converter.isOfType(cls)).findFirst();
    }

    public Object convert(Object arg) {
        return this.getConverter(arg.getClass()).map(converter -> converter.convert(arg)).orElse(arg);
    }
}

