/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.converters.output;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.adridadou.ethereum.converters.output.OutputTypeConverter;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;

public class ArrayConverter
implements OutputTypeConverter {
    private final OutputTypeHandler handler;

    public ArrayConverter(OutputTypeHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean isOfType(Class<?> cls) {
        return cls.isArray();
    }

    @Override
    public Object convert(Object obj, Type genericType) {
        Object[] arr = (Object[])obj;
        return this.handler.getConverter(this.getGenericType(genericType)).map(converter -> Arrays.stream(arr).map(o -> converter.convert(o, genericType)).collect(Collectors.toList())).orElseThrow(() -> new IllegalArgumentException("no handler founds to convert " + genericType.getTypeName())).toArray((Object[])Array.newInstance(this.getGenericType(genericType), arr.length));
    }

    private Class<?> getGenericType(Type genericType) {
        return (Class)genericType;
    }
}

