/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.converters.output;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.adridadou.ethereum.converters.output.AddressConverter;
import org.adridadou.ethereum.converters.output.ArrayConverter;
import org.adridadou.ethereum.converters.output.BooleanConverter;
import org.adridadou.ethereum.converters.output.CompletableFutureConverter;
import org.adridadou.ethereum.converters.output.EnumConverter;
import org.adridadou.ethereum.converters.output.IntegerConverter;
import org.adridadou.ethereum.converters.output.ListConverter;
import org.adridadou.ethereum.converters.output.LongConverter;
import org.adridadou.ethereum.converters.output.OutputTypeConverter;
import org.adridadou.ethereum.converters.output.SetConverter;
import org.adridadou.ethereum.converters.output.StringConverter;
import org.adridadou.ethereum.converters.output.VoidConverter;

public class OutputTypeHandler {
    public static final List<OutputTypeConverter> JAVA_OUTPUT_CONVERTERS = ImmutableList.builder().add((Object[])new OutputTypeConverter[]{new IntegerConverter(), new LongConverter(), new StringConverter(), new BooleanConverter(), new AddressConverter(), new VoidConverter(), new EnumConverter()}).build();
    private final List<OutputTypeConverter> outputConverters = new ArrayList<OutputTypeConverter>();

    public OutputTypeHandler() {
        this.addConverters(JAVA_OUTPUT_CONVERTERS);
        this.addConverters(new ListConverter(this), new ArrayConverter(this), new CompletableFutureConverter(this), new SetConverter(this));
    }

    public void addConverters(OutputTypeConverter ... converters) {
        this.addConverters(Lists.newArrayList((Object[])converters));
    }

    public void addConverters(Collection<OutputTypeConverter> converters) {
        this.outputConverters.addAll(converters);
    }

    public Optional<OutputTypeConverter> getConverter(Class<?> cls) {
        return this.outputConverters.stream().filter(converter -> converter.isOfType(cls)).findFirst();
    }
}

