/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.typesafe.config.ConfigFactory;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainConfig;
import org.adridadou.ethereum.blockchain.BlockchainProxyReal;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.values.config.ChainId;
import org.ethereum.config.SystemProperties;
import org.ethereum.facade.Ethereum;
import org.ethereum.facade.EthereumFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

public class GenericEthereumFacadeProvider {
    private static final Logger log = LoggerFactory.getLogger(GenericEthereumFacadeProvider.class);
    public static final ChainId MAIN_CHAIN_ID = ChainId.id(0);
    public static final ChainId ROPSTEN_CHAIN_ID = ChainId.id(3);

    public EthereumFacade create(BlockchainConfig config) {
        return this.create(new OnBlockHandler(), new OnTransactionHandler(), config);
    }

    public EthereumFacade create(OnBlockHandler onBlockHandler, OnTransactionHandler onTransactionHandler, BlockchainConfig config) {
        GenericConfig.config = config.toString();
        log.info("config:" + GenericConfig.config);
        Ethereum ethereum = EthereumFactory.createEthereum(GenericConfig.class);
        EthereumEventHandler ethereumListener = new EthereumEventHandler(ethereum, onBlockHandler, onTransactionHandler);
        ethereum.init();
        return new EthereumFacade(new BlockchainProxyReal(ethereum, ethereumListener));
    }

    private static class GenericConfig {
        static String config;

        private GenericConfig() {
        }

        @Bean
        public SystemProperties systemProperties() {
            SystemProperties props = new SystemProperties();
            props.overrideParams(ConfigFactory.parseString((String)config.replaceAll("'", "\"")));
            return props;
        }
    }
}

