/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.keystore.FileSecureKey;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.provider.EthereumFacadeProvider;
import org.adridadou.ethereum.provider.GenericEthereumFacadeProvider;
import org.adridadou.ethereum.provider.GenericRpcEthereumFacadeProvider;
import org.adridadou.ethereum.values.config.InfuraKey;
import org.adridadou.exception.EthereumApiException;
import org.web3j.crypto.WalletUtils;

public class InfuraRopstenEthereumFacadeProvider
implements EthereumFacadeProvider {
    public EthereumFacade create(InfuraKey key) {
        return new GenericRpcEthereumFacadeProvider().create("https://ropsten.infura.io/" + key.key, GenericEthereumFacadeProvider.ROPSTEN_CHAIN_ID);
    }

    @Override
    public SecureKey getLockedAccount(String id) {
        return this.listAvailableKeys().stream().filter(file -> file.getName().equals(id)).findFirst().orElseThrow(() -> {
            String names = this.listAvailableKeys().stream().map(FileSecureKey::getName).reduce((aggregate, name) -> aggregate + "," + name).orElse("");
            return new EthereumApiException("could not find the keyfile " + id + " available:" + names);
        });
    }

    private String getKeystoreFolderPath() {
        return WalletUtils.getTestnetKeyDirectory();
    }

    public List<FileSecureKey> listAvailableKeys() {
        Object[] files = Optional.ofNullable(new File(this.getKeystoreFolderPath()).listFiles()).orElseThrow(() -> new EthereumApiException("cannot find the folder " + this.getKeystoreFolderPath()));
        return Lists.newArrayList((Object[])files).stream().filter(File::isFile).map(FileSecureKey::new).collect(Collectors.toList());
    }
}

