/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainProxyReal;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.keystore.StringSecureKey;
import org.adridadou.ethereum.provider.PrivateNetworkConfig;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.exception.EthereumApiException;
import org.apache.commons.io.FileUtils;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.Block;
import org.ethereum.facade.Ethereum;
import org.ethereum.facade.EthereumFactory;
import org.ethereum.mine.Ethash;
import org.ethereum.mine.MinerListener;
import org.ethereum.samples.BasicSample;
import org.springframework.context.annotation.Bean;

public class PrivateEthereumFacadeProvider {
    private static final EthAccount mainAccount = new StringSecureKey("cow").decode("");

    private void deleteFolder(File folder, boolean root) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f, false);
                    continue;
                }
                f.delete();
            }
        }
        if (!root) {
            folder.delete();
        }
    }

    public EthereumFacade create(PrivateNetworkConfig config) throws Exception {
        boolean dagCached = new File("cachedDag/mine-dag.dat").exists();
        if (config.isResetPrivateBlockchain()) {
            this.deleteFolder(new File(config.getDbName()), true);
        }
        if (dagCached) {
            new File(config.getDbName()).mkdirs();
            FileUtils.copyFile((File)new File("cachedDag/mine-dag.dat"), (File)new File(config.getDbName() + "/mine-dag.dat"));
            FileUtils.copyFile((File)new File("cachedDag/mine-dag-light.dat"), (File)new File(config.getDbName() + "/mine-dag-light.dat"));
        }
        MinerConfig.dbName = config.getDbName();
        Ethereum ethereum = EthereumFactory.createEthereum(MinerConfig.class);
        ethereum.init();
        while (!ethereum.getBlockMiner().isMining()) {
            Thread.sleep(100L);
        }
        if (!dagCached) {
            FileUtils.copyFile((File)new File(config.getDbName() + "/mine-dag.dat"), (File)new File("cachedDag/mine-dag.dat"));
            FileUtils.copyFile((File)new File(config.getDbName() + "/mine-dag-light.dat"), (File)new File("cachedDag/mine-dag-light.dat"));
        }
        EthereumEventHandler ethereumListener = new EthereumEventHandler(ethereum, new OnBlockHandler(), new OnTransactionHandler());
        EthereumFacade facade = new EthereumFacade(new BlockchainProxyReal(ethereum, ethereumListener));
        ethereumListener.onSyncDone();
        facade.events().onReady().thenAccept(b -> config.getInitialBalances().entrySet().stream().map(entry -> facade.sendEther(mainAccount, ((EthAccount)entry.getKey()).getAddress(), (EthValue)entry.getValue())).forEach(result -> {
            try {
                result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new EthereumApiException("error while setting the initial balances");
            }
        }));
        return facade;
    }

    public SecureKey getKey(String id) {
        return new StringSecureKey(id);
    }

    private static class RegularConfig {
        private RegularConfig() {
        }

        @Bean
        public SystemProperties systemProperties() {
            SystemProperties props = new SystemProperties(ConfigFactory.empty(), PrivateEthereumFacadeProvider.class.getClassLoader());
            props.overrideParams(ConfigFactory.parseString((String)"peer.discovery.enabled = false \npeer.listen.port = 30336 \npeer.privateKey = 3ec771c31cac8c0dba77a69e503765701d3c2bb62435888d4ffa38fed60c445c \npeer.networkId = 555 \npeer.active = [    { url = 'enode://26ba1aadaf59d7607ad7f437146927d79e80312f026cfa635c6b2ccf2c5d3521f5812ca2beb3b295b14f97110e6448c1c7ff68f14c5328d43a3c62b44143e9b1@localhost:30335' }] \nsync.enabled = true \ngenesis = private-genesis.json \ndatabase.dir = sampleDB-2 \n".replaceAll("'", "\"")));
            return props;
        }
    }

    static class MinerNode
    extends BasicSample
    implements MinerListener {
        public MinerNode() {
            super("sampleMiner");
        }

        public void run() {
            if (this.config.isMineFullDataset()) {
                this.logger.info("Generating Full Dataset (may take up to 10 min if not cached)...");
                Ethash ethash = Ethash.getForBlock((SystemProperties)this.config, (long)this.ethereum.getBlockchain().getBestBlock().getNumber());
                ethash.getFullDataset();
                this.logger.info("Full dataset generated (loaded).");
            }
            this.ethereum.getBlockMiner().addListener((MinerListener)this);
            this.ethereum.getBlockMiner().startMining();
        }

        public void miningStarted() {
            this.logger.info("Miner started");
        }

        public void miningStopped() {
            this.logger.info("Miner stopped");
        }

        public void blockMiningStarted(Block block) {
            this.logger.info("Start mining block: " + block.getShortDescr());
        }

        public void blockMined(Block block) {
            this.logger.info("Block mined! : \n" + block);
        }

        public void blockMiningCanceled(Block block) {
            this.logger.info("Cancel mining block: " + block.getShortDescr());
        }
    }

    private static class MinerConfig {
        public static String dbName = "sampleDB";

        private MinerConfig() {
        }

        public static String config() {
            return "peer.discovery.enabled = false \npeer.listen.port = 30335 \npeer.privateKey = 6ef8da380c27cea8fdf7448340ea99e8e2268fc2950d79ed47cbf6f85dc977ec \npeer.networkId = 555 \nsync.enabled = false \ngenesis = private-genesis.json \ndatabase.dir = " + dbName + " \nmine.extraDataHex = cccccccccccccccccccc \nmine.cpuMineThreads = 2 \ncache.flush.blocks = 1";
        }

        @Bean
        public MinerNode node() {
            return new MinerNode();
        }

        @Bean
        public SystemProperties systemProperties() {
            SystemProperties props = new SystemProperties(ConfigFactory.empty(), PrivateEthereumFacadeProvider.class.getClassLoader());
            props.overrideParams(ConfigFactory.parseString((String)MinerConfig.config().replaceAll("'", "\"")));
            return props;
        }
    }
}

