/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.BlockchainConfig;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.keystore.FileSecureKey;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.provider.EthereumFacadeProvider;
import org.adridadou.ethereum.provider.GenericEthereumFacadeProvider;
import org.adridadou.ethereum.values.config.DatabaseDirectory;
import org.adridadou.ethereum.values.config.EthereumConfigName;
import org.adridadou.ethereum.values.config.GenesisPath;
import org.adridadou.ethereum.values.config.NodeIp;
import org.adridadou.exception.EthereumApiException;
import org.web3j.crypto.WalletUtils;

public class RopstenEthereumFacadeProvider
implements EthereumFacadeProvider {
    public EthereumFacade create() {
        return this.create(new OnBlockHandler(), new OnTransactionHandler());
    }

    public EthereumFacade create(OnBlockHandler onBlockHandler, OnTransactionHandler onTransactionHandler) {
        return new GenericEthereumFacadeProvider().create(onBlockHandler, onTransactionHandler, BlockchainConfig.builder().addIp(NodeIp.ip("94.242.229.4:40404")).addIp(NodeIp.ip("94.242.229.203:30303")).networkId(GenericEthereumFacadeProvider.ROPSTEN_CHAIN_ID).eip8(true).genesis(GenesisPath.path("ropsten.json")).configName(EthereumConfigName.name("ropsten")).dbDirectory(DatabaseDirectory.db("database-ropsten")).build());
    }

    @Override
    public SecureKey getLockedAccount(String id) {
        return this.listAvailableKeys().stream().filter(file -> file.getName().equals(id)).findFirst().orElseThrow(() -> {
            String names = this.listAvailableKeys().stream().map(FileSecureKey::getName).reduce((aggregate, name) -> aggregate + "," + name).orElse("");
            return new EthereumApiException("could not find the keyfile " + id + " available:" + names);
        });
    }

    private String getKeystoreFolderPath() {
        return WalletUtils.getTestnetKeyDirectory();
    }

    public List<FileSecureKey> listAvailableKeys() {
        Object[] files = Optional.ofNullable(new File(this.getKeystoreFolderPath()).listFiles()).orElseThrow(() -> new EthereumApiException("cannot find the folder " + this.getKeystoreFolderPath()));
        return Lists.newArrayList((Object[])files).stream().filter(File::isFile).map(FileSecureKey::new).collect(Collectors.toList());
    }
}

