/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.smartcontract;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.blockchain.BlockchainProxyRpc;
import org.adridadou.ethereum.blockchain.Web3JFacade;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;

public class SmartContractRpc
implements SmartContract {
    private final EthAddress address;
    private final CallTransaction.Contract contract;
    private final Web3JFacade web3j;
    private final BlockchainProxyRpc bcProxy;
    private final EthAccount sender;

    public SmartContractRpc(String abi, Web3JFacade web3j, EthAccount sender, EthAddress address, BlockchainProxyRpc bcProxy) {
        this.contract = new CallTransaction.Contract(abi);
        this.web3j = web3j;
        this.sender = sender;
        this.bcProxy = bcProxy;
        this.address = address;
    }

    @Override
    public List<CallTransaction.Function> getFunctions() {
        return Lists.newArrayList((Object[])this.contract.functions);
    }

    @Override
    public Object[] callConstFunction(String functionName, Object ... args) {
        return Optional.ofNullable(this.contract.getByName(functionName)).map(func -> {
            EthData result = this.web3j.constantCall(this.sender, this.address, EthData.of(func.encode(args)));
            return func.decodeResult(result.data);
        }).orElseThrow(() -> new EthereumApiException("function " + functionName + " cannot be found. available:" + this.getAvailableFunctions()));
    }

    @Override
    public CompletableFuture<Object[]> callFunction(String functionName, Object ... args) {
        return this.callFunction(EthValue.wei(0), functionName, args);
    }

    public CompletableFuture<Object[]> callFunction(EthValue value, String functionName, Object ... args) {
        return Optional.ofNullable(this.contract.getByName(functionName)).map(func -> this.bcProxy.sendTx(value, EthData.of(func.encode(args)), this.sender, this.address).thenApply(receipt -> Optional.ofNullable(receipt.getResult()).map(result -> this.contract.getByName(functionName).decodeResult(result)).orElse(null))).orElseThrow(() -> new EthereumApiException("function " + functionName + " cannot be found. available:" + this.getAvailableFunctions()));
    }

    private String getAvailableFunctions() {
        ArrayList<String> names = new ArrayList<String>();
        for (CallTransaction.Function func : this.contract.functions) {
            names.add(func.name);
        }
        return ((Object)names).toString();
    }

    public EthAddress getAddress() {
        return this.address;
    }
}

