/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import java.math.BigInteger;
import org.adridadou.ethereum.values.EthAddress;
import org.ethereum.crypto.ECKey;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;

public class EthAccount {
    public final ECKey key;
    public final Credentials credentials;

    public EthAccount(ECKey key) {
        this.key = key;
        ECKeyPair keyPair = ECKeyPair.create((BigInteger)key.getPrivKey());
        this.credentials = Credentials.create((ECKeyPair)keyPair);
    }

    public EthAddress getAddress() {
        return EthAddress.of(this.key.getAddress());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthAccount that = (EthAccount)o;
        return this.key != null ? this.key.equals((Object)that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return "account address:" + this.getAddress().withLeading0x();
    }
}

