/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import java.math.BigDecimal;
import java.math.BigInteger;

public class EthValue
implements Comparable<EthValue> {
    private final BigDecimal value;
    private static final BigDecimal ETHER_CONVERSION = BigDecimal.valueOf(1000000000000000000L);

    public EthValue(BigInteger value) {
        this.value = new BigDecimal(value);
    }

    public static EthValue ether(BigInteger value) {
        return new EthValue(value.multiply(ETHER_CONVERSION.toBigInteger()));
    }

    public static EthValue ether(long value) {
        return EthValue.ether(BigInteger.valueOf(value));
    }

    public static EthValue wei(int value) {
        return EthValue.wei(BigInteger.valueOf(value));
    }

    public static EthValue wei(BigInteger value) {
        return new EthValue(value);
    }

    public BigInteger inWei() {
        return this.value.toBigInteger();
    }

    public BigDecimal inEth() {
        return this.value.divide(ETHER_CONVERSION, 3);
    }

    @Override
    public int compareTo(EthValue o) {
        return this.value.compareTo(o.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthValue ethValue = (EthValue)o;
        return this.value.equals(ethValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value + " Wei";
    }
}

