/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.EthereumContractInvocationHandler;
import org.adridadou.ethereum.blockchain.EthereumProxy;
import org.adridadou.ethereum.converters.input.InputTypeConverter;
import org.adridadou.ethereum.converters.input.InputTypeHandler;
import org.adridadou.ethereum.converters.output.OutputTypeConverter;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.adridadou.ethereum.swarm.SwarmHash;
import org.adridadou.ethereum.swarm.SwarmService;
import org.adridadou.ethereum.values.CompiledContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SmartContractByteCode;
import org.adridadou.ethereum.values.SoliditySource;
import org.adridadou.ethereum.values.SwarmMetadaLink;
import org.adridadou.ethereum.values.smartcontract.SmartContractMetadata;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import rx.Observable;

public class EthereumFacade {
    public static final Charset CHARSET = Charsets.UTF_8;
    private final EthereumContractInvocationHandler handler;
    private final OutputTypeHandler outputTypeHandler;
    private final InputTypeHandler inputTypeHandler;
    private final EthereumProxy ethereumProxy;
    private final SwarmService swarmService;
    private final SolidityCompiler solidityCompiler;

    public EthereumFacade(EthereumProxy ethereumProxy, InputTypeHandler inputTypeHandler, OutputTypeHandler outputTypeHandler, SwarmService swarmService, SolidityCompiler solidityCompiler) {
        this.inputTypeHandler = inputTypeHandler;
        this.outputTypeHandler = outputTypeHandler;
        this.swarmService = swarmService;
        this.solidityCompiler = solidityCompiler;
        this.handler = new EthereumContractInvocationHandler(ethereumProxy, inputTypeHandler, outputTypeHandler);
        this.ethereumProxy = ethereumProxy;
    }

    public EthereumFacade addInputHandlers(List<InputTypeConverter> handlers) {
        this.inputTypeHandler.addConverters(handlers);
        return this;
    }

    public EthereumFacade addOutputHandlers(List<OutputTypeConverter> handlers) {
        this.outputTypeHandler.addConverters(handlers);
        return this;
    }

    public <T> T createContractProxy(CompiledContract contract, EthAddress address, EthAccount account, Class<T> contractInterface) {
        return this.createContractProxy(contract.getAbi(), address, account, contractInterface);
    }

    public <T> T createContractProxy(EthAddress address, EthAccount account, Class<T> contractInterface) {
        return this.createContractProxy(this.getAbi(address), address, account, contractInterface);
    }

    public <T> T createContractProxy(ContractAbi abi, EthAddress address, EthAccount account, Class<T> contractInterface) {
        Object proxy = Proxy.newProxyInstance(contractInterface.getClassLoader(), new Class[]{contractInterface}, (InvocationHandler)this.handler);
        this.handler.register(proxy, contractInterface, abi, address, account);
        return (T)proxy;
    }

    public <T> Builder<T> createContractProxy(EthAddress address, Class<T> contractInterface) {
        return new Builder<T>(contractInterface, address, this.getAbi(address));
    }

    public <T> Builder<T> createContractProxy(EthAddress address, ContractAbi abi, Class<T> contractInterface) {
        return new Builder<T>(contractInterface, address, abi);
    }

    public <T> Builder<T> createContractProxy(CompiledContract contract, EthAddress address, Class<T> contractInterface) {
        return new Builder<T>(contractInterface, address, contract.getAbi());
    }

    public ContractAbi getAbi(EthAddress address) {
        SmartContractByteCode code = this.ethereumProxy.getCode(address);
        SmartContractMetadata metadata = this.getMetadata(code.getMetadaLink().orElseThrow(() -> new EthereumApiException("no metadata link found for smart contract on address " + address.toString())));
        return metadata.getAbi();
    }

    public CompletableFuture<EthAddress> publishContract(CompiledContract contract, EthAccount sender, Object ... constructorArgs) {
        return this.ethereumProxy.publish(contract, sender, constructorArgs);
    }

    public SwarmHash publishMetadataToSwarm(CompiledContract contract) {
        return this.swarmService.publish(contract.getMetadata().getValue());
    }

    public boolean addressExists(EthAddress address) {
        return this.ethereumProxy.addressExists(address);
    }

    public EthValue getBalance(EthAddress addr) {
        return this.ethereumProxy.getBalance(addr);
    }

    public EthValue getBalance(EthAccount account) {
        return this.ethereumProxy.getBalance(account.getAddress());
    }

    public EthereumEventHandler events() {
        return this.ethereumProxy.events();
    }

    public CompletableFuture<EthExecutionResult> sendEther(EthAccount fromAccount, EthAddress to, EthValue value) {
        return this.ethereumProxy.sendTx(value, EthData.empty(), fromAccount, to);
    }

    public BigInteger getNonce(EthAddress address) {
        return this.ethereumProxy.getNonce(address);
    }

    public SmartContractByteCode getCode(EthAddress address) {
        return this.ethereumProxy.getCode(address);
    }

    public SmartContractMetadata getMetadata(SwarmMetadaLink swarmMetadaLink) {
        try {
            return this.swarmService.getMetadata(swarmMetadaLink.getHash());
        }
        catch (IOException e) {
            throw new EthereumApiException("error while getting metadata", e);
        }
    }

    public void shutdown() {
        this.ethereumProxy.shutdown();
    }

    public CompletableFuture<CompiledContract> compile(SoliditySource src, String contractName) {
        return CompletableFuture.supplyAsync(() -> this.compileInternal(src, contractName));
    }

    private CompiledContract compileInternal(SoliditySource src, String contractName) {
        try {
            SolidityCompiler.Result result = this.solidityCompiler.compileSrc(src.getSource().getBytes(CHARSET), true, true, new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.METADATA});
            if (result.isFailed()) {
                throw new EthereumApiException("Contract compilation failed:\n" + result.errors);
            }
            CompilationResult res = CompilationResult.parse((String)result.output);
            if (res.contracts.isEmpty()) {
                throw new EthereumApiException("Compilation failed, no contracts returned:\n" + result.errors);
            }
            CompilationResult.ContractMetadata metadata = (CompilationResult.ContractMetadata)res.contracts.get(contractName);
            if (metadata == null) {
                throw new EthereumApiException("No contract found with the name " + contractName + " available:" + res.contracts.keySet());
            }
            if (metadata.bin == null || metadata.bin.isEmpty()) {
                throw new EthereumApiException("Compilation failed, no binary returned:\n" + result.errors);
            }
            return CompiledContract.from(src, contractName, metadata);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while compiling " + contractName, e);
        }
    }

    public <T> Observable<T> observeEvents(ContractAbi abi, EthAddress address, String eventName, Class<T> cls) {
        return this.ethereumProxy.observeEvents(abi, address, eventName, cls);
    }

    public class Builder<T> {
        private final Class<T> contractInterface;
        private final EthAddress address;
        private final ContractAbi abi;

        public Builder(Class<T> contractInterface, EthAddress address, ContractAbi abi) {
            this.contractInterface = contractInterface;
            this.address = address;
            this.abi = abi;
        }

        public T forAccount(EthAccount account) {
            Object proxy = Proxy.newProxyInstance(this.contractInterface.getClassLoader(), new Class[]{this.contractInterface}, (InvocationHandler)EthereumFacade.this.handler);
            EthereumFacade.this.handler.register(proxy, this.contractInterface, this.abi, this.address, account);
            return (T)proxy;
        }
    }
}

